/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Translation.Builder.class)
public final class Translation {
    private final String name;

    private final String description;

    private final String locale;

    private final Map<String, Object> additionalProperties;

    private Translation(String name, String description, String locale, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The localised name of the subscription type.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The localised description of the subscription type.
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * @return The two character identifier for the language of the translation object.
     */
    @JsonProperty("locale")
    public String getLocale() {
        return locale;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Translation && equalTo((Translation) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Translation other) {
        return name.equals(other.name) && description.equals(other.description) && locale.equals(other.locale);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.description, this.locale);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * The localised name of the subscription type.
         */
        DescriptionStage name(@NotNull String name);

        Builder from(Translation other);
    }

    public interface DescriptionStage {
        /**
         * The localised description of the subscription type.
         */
        LocaleStage description(@NotNull String description);
    }

    public interface LocaleStage {
        /**
         * The two character identifier for the language of the translation object.
         */
        _FinalStage locale(@NotNull String locale);
    }

    public interface _FinalStage {
        Translation build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, DescriptionStage, LocaleStage, _FinalStage {
        private String name;

        private String description;

        private String locale;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Translation other) {
            name(other.getName());
            description(other.getDescription());
            locale(other.getLocale());
            return this;
        }

        /**
         * The localised name of the subscription type.<p>The localised name of the subscription type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The localised description of the subscription type.<p>The localised description of the subscription type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("description")
        public LocaleStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        /**
         * The two character identifier for the language of the translation object.<p>The two character identifier for the language of the translation object.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("locale")
        public _FinalStage locale(@NotNull String locale) {
            this.locale = Objects.requireNonNull(locale, "locale must not be null");
            return this;
        }

        @java.lang.Override
        public Translation build() {
            return new Translation(name, description, locale, additionalProperties);
        }
    }
}
