/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.admins.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.TeamPriorityLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Admin {
    private final Optional<String> type;
    private final String id;
    private final String name;
    private final String email;
    private final String jobTitle;
    private final boolean awayModeEnabled;
    private final boolean awayModeReassign;
    private final boolean hasInboxSeat;
    private final List<Integer> teamIds;
    private final Optional<Avatar> avatar;
    private final Optional<TeamPriorityLevel> teamPriorityLevel;
    private final Map<String, Object> additionalProperties;

    private Admin(Optional<String> type, String id, String name, String email, String jobTitle, boolean awayModeEnabled, boolean awayModeReassign, boolean hasInboxSeat, List<Integer> teamIds, Optional<Avatar> avatar, Optional<TeamPriorityLevel> teamPriorityLevel, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.jobTitle = jobTitle;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.hasInboxSeat = hasInboxSeat;
        this.teamIds = teamIds;
        this.avatar = avatar;
        this.teamPriorityLevel = teamPriorityLevel;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="job_title")
    public String getJobTitle() {
        return this.jobTitle;
    }

    @JsonProperty(value="away_mode_enabled")
    public boolean getAwayModeEnabled() {
        return this.awayModeEnabled;
    }

    @JsonProperty(value="away_mode_reassign")
    public boolean getAwayModeReassign() {
        return this.awayModeReassign;
    }

    @JsonProperty(value="has_inbox_seat")
    public boolean getHasInboxSeat() {
        return this.hasInboxSeat;
    }

    @JsonProperty(value="team_ids")
    public List<Integer> getTeamIds() {
        return this.teamIds;
    }

    @JsonProperty(value="avatar")
    public Optional<Avatar> getAvatar() {
        return this.avatar;
    }

    @JsonProperty(value="team_priority_level")
    public Optional<TeamPriorityLevel> getTeamPriorityLevel() {
        return this.teamPriorityLevel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Admin && this.equalTo((Admin)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Admin other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.email.equals(other.email) && this.jobTitle.equals(other.jobTitle) && this.awayModeEnabled == other.awayModeEnabled && this.awayModeReassign == other.awayModeReassign && this.hasInboxSeat == other.hasInboxSeat && this.teamIds.equals(other.teamIds) && this.avatar.equals(other.avatar) && this.teamPriorityLevel.equals(other.teamPriorityLevel);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email, this.jobTitle, this.awayModeEnabled, this.awayModeReassign, this.hasInboxSeat, this.teamIds, this.avatar, this.teamPriorityLevel);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Avatar {
        private final String imageUrl;
        private final Map<String, Object> additionalProperties;

        private Avatar(String imageUrl, Map<String, Object> additionalProperties) {
            this.imageUrl = imageUrl;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="image_url")
        public String getImageUrl() {
            return this.imageUrl;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Avatar && this.equalTo((Avatar)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Avatar other) {
            return this.imageUrl.equals(other.imageUrl);
        }

        public int hashCode() {
            return Objects.hash(this.imageUrl);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ImageUrlStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements ImageUrlStage,
        _FinalStage {
            private String imageUrl;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(Avatar other) {
                this.imageUrl(other.getImageUrl());
                return this;
            }

            @Override
            @JsonSetter(value="image_url")
            public _FinalStage imageUrl(@NotNull String imageUrl) {
                this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl must not be null");
                return this;
            }

            @Override
            public Avatar build() {
                return new Avatar(this.imageUrl, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public Avatar build();
        }

        public static interface ImageUrlStage {
            public _FinalStage imageUrl(@NotNull String var1);

            public Builder from(Avatar var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    EmailStage,
    JobTitleStage,
    AwayModeEnabledStage,
    AwayModeReassignStage,
    HasInboxSeatStage,
    _FinalStage {
        private String id;
        private String name;
        private String email;
        private String jobTitle;
        private boolean awayModeEnabled;
        private boolean awayModeReassign;
        private boolean hasInboxSeat;
        private Optional<TeamPriorityLevel> teamPriorityLevel = Optional.empty();
        private Optional<Avatar> avatar = Optional.empty();
        private List<Integer> teamIds = new ArrayList<Integer>();
        private Optional<String> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Admin other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.email(other.getEmail());
            this.jobTitle(other.getJobTitle());
            this.awayModeEnabled(other.getAwayModeEnabled());
            this.awayModeReassign(other.getAwayModeReassign());
            this.hasInboxSeat(other.getHasInboxSeat());
            this.teamIds(other.getTeamIds());
            this.avatar(other.getAvatar());
            this.teamPriorityLevel(other.getTeamPriorityLevel());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public EmailStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public JobTitleStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="job_title")
        public AwayModeEnabledStage jobTitle(@NotNull String jobTitle) {
            this.jobTitle = Objects.requireNonNull(jobTitle, "jobTitle must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="away_mode_enabled")
        public AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        @Override
        @JsonSetter(value="away_mode_reassign")
        public HasInboxSeatStage awayModeReassign(boolean awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        @Override
        @JsonSetter(value="has_inbox_seat")
        public _FinalStage hasInboxSeat(boolean hasInboxSeat) {
            this.hasInboxSeat = hasInboxSeat;
            return this;
        }

        @Override
        public _FinalStage teamPriorityLevel(TeamPriorityLevel teamPriorityLevel) {
            this.teamPriorityLevel = Optional.ofNullable(teamPriorityLevel);
            return this;
        }

        @Override
        @JsonSetter(value="team_priority_level", nulls=Nulls.SKIP)
        public _FinalStage teamPriorityLevel(Optional<TeamPriorityLevel> teamPriorityLevel) {
            this.teamPriorityLevel = teamPriorityLevel;
            return this;
        }

        @Override
        public _FinalStage avatar(Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @Override
        @JsonSetter(value="avatar", nulls=Nulls.SKIP)
        public _FinalStage avatar(Optional<Avatar> avatar) {
            this.avatar = avatar;
            return this;
        }

        @Override
        public _FinalStage addAllTeamIds(List<Integer> teamIds) {
            this.teamIds.addAll(teamIds);
            return this;
        }

        @Override
        public _FinalStage addTeamIds(Integer teamIds) {
            this.teamIds.add(teamIds);
            return this;
        }

        @Override
        @JsonSetter(value="team_ids", nulls=Nulls.SKIP)
        public _FinalStage teamIds(List<Integer> teamIds) {
            this.teamIds.clear();
            this.teamIds.addAll(teamIds);
            return this;
        }

        @Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @Override
        public Admin build() {
            return new Admin(this.type, this.id, this.name, this.email, this.jobTitle, this.awayModeEnabled, this.awayModeReassign, this.hasInboxSeat, this.teamIds, this.avatar, this.teamPriorityLevel, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Admin build();

        public _FinalStage type(Optional<String> var1);

        public _FinalStage type(String var1);

        public _FinalStage teamIds(List<Integer> var1);

        public _FinalStage addTeamIds(Integer var1);

        public _FinalStage addAllTeamIds(List<Integer> var1);

        public _FinalStage avatar(Optional<Avatar> var1);

        public _FinalStage avatar(Avatar var1);

        public _FinalStage teamPriorityLevel(Optional<TeamPriorityLevel> var1);

        public _FinalStage teamPriorityLevel(TeamPriorityLevel var1);
    }

    public static interface HasInboxSeatStage {
        public _FinalStage hasInboxSeat(boolean var1);
    }

    public static interface AwayModeReassignStage {
        public HasInboxSeatStage awayModeReassign(boolean var1);
    }

    public static interface AwayModeEnabledStage {
        public AwayModeReassignStage awayModeEnabled(boolean var1);
    }

    public static interface JobTitleStage {
        public AwayModeEnabledStage jobTitle(@NotNull String var1);
    }

    public static interface EmailStage {
        public JobTitleStage email(@NotNull String var1);
    }

    public static interface NameStage {
        public EmailStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Admin var1);
    }
}

