/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.companies;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.companies.AsyncRawCompaniesClient;
import com.intercom.api.resources.companies.requests.AttachContactToCompanyRequest;
import com.intercom.api.resources.companies.requests.CreateOrUpdateCompanyRequest;
import com.intercom.api.resources.companies.requests.DeleteCompanyRequest;
import com.intercom.api.resources.companies.requests.DetachContactFromCompanyRequest;
import com.intercom.api.resources.companies.requests.FindCompanyRequest;
import com.intercom.api.resources.companies.requests.ListAttachedContactsRequest;
import com.intercom.api.resources.companies.requests.ListCompaniesRequest;
import com.intercom.api.resources.companies.requests.ListSegmentsAttachedToCompanyRequest;
import com.intercom.api.resources.companies.requests.RetrieveCompanyRequest;
import com.intercom.api.resources.companies.requests.ScrollCompaniesRequest;
import com.intercom.api.resources.companies.requests.UpdateCompanyRequest;
import com.intercom.api.resources.companies.types.CompaniesRetrieveResponse;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.types.CompanyAttachedContacts;
import com.intercom.api.types.CompanyAttachedSegments;
import com.intercom.api.types.DeletedCompanyObject;
import java.util.concurrent.CompletableFuture;

public class AsyncCompaniesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCompaniesClient rawClient;

    public AsyncCompaniesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCompaniesClient(clientOptions);
    }

    public AsyncRawCompaniesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CompaniesRetrieveResponse> retrieve() {
        return this.rawClient.retrieve().thenApply(response -> (CompaniesRetrieveResponse)response.body());
    }

    public CompletableFuture<CompaniesRetrieveResponse> retrieve(RetrieveCompanyRequest request) {
        return this.rawClient.retrieve(request).thenApply(response -> (CompaniesRetrieveResponse)response.body());
    }

    public CompletableFuture<CompaniesRetrieveResponse> retrieve(RetrieveCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieve(request, requestOptions).thenApply(response -> (CompaniesRetrieveResponse)response.body());
    }

    public CompletableFuture<Company> createOrUpdate() {
        return this.rawClient.createOrUpdate().thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> createOrUpdate(CreateOrUpdateCompanyRequest request) {
        return this.rawClient.createOrUpdate(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> createOrUpdate(CreateOrUpdateCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.createOrUpdate(request, requestOptions).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> find(FindCompanyRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> find(FindCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> update(UpdateCompanyRequest request) {
        return this.rawClient.update(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> update(UpdateCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<DeletedCompanyObject> delete(DeleteCompanyRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeletedCompanyObject)response.body());
    }

    public CompletableFuture<DeletedCompanyObject> delete(DeleteCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeletedCompanyObject)response.body());
    }

    public CompletableFuture<CompanyAttachedContacts> listAttachedContacts(ListAttachedContactsRequest request) {
        return this.rawClient.listAttachedContacts(request).thenApply(response -> (CompanyAttachedContacts)response.body());
    }

    public CompletableFuture<CompanyAttachedContacts> listAttachedContacts(ListAttachedContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedContacts(request, requestOptions).thenApply(response -> (CompanyAttachedContacts)response.body());
    }

    public CompletableFuture<CompanyAttachedSegments> listAttachedSegments(ListSegmentsAttachedToCompanyRequest request) {
        return this.rawClient.listAttachedSegments(request).thenApply(response -> (CompanyAttachedSegments)response.body());
    }

    public CompletableFuture<CompanyAttachedSegments> listAttachedSegments(ListSegmentsAttachedToCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSegments(request, requestOptions).thenApply(response -> (CompanyAttachedSegments)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Company>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Company>> list(ListCompaniesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Company>> list(ListCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Company>> scroll() {
        return this.rawClient.scroll().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Company>> scroll(ScrollCompaniesRequest request) {
        return this.rawClient.scroll(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Company>> scroll(ScrollCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.scroll(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<Company> attachContact(AttachContactToCompanyRequest request) {
        return this.rawClient.attachContact(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> attachContact(AttachContactToCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContact(request, requestOptions).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> detachContact(DetachContactFromCompanyRequest request) {
        return this.rawClient.detachContact(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> detachContact(DetachContactFromCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContact(request, requestOptions).thenApply(response -> (Company)response.body());
    }
}

