/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.aiagent.types.AiAgent;
import com.intercom.api.types.ConversationContacts;
import com.intercom.api.types.ConversationFirstContactReply;
import com.intercom.api.types.ConversationParts;
import com.intercom.api.types.ConversationRating;
import com.intercom.api.types.ConversationSource;
import com.intercom.api.types.ConversationStatistics;
import com.intercom.api.types.ConversationTeammates;
import com.intercom.api.types.LinkedObjectList;
import com.intercom.api.types.SlaApplied;
import com.intercom.api.types.Tags;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Conversation {
    private final Optional<String> type;
    private final String id;
    private final Optional<String> title;
    private final int createdAt;
    private final int updatedAt;
    private final Optional<Integer> waitingSince;
    private final Optional<Integer> snoozedUntil;
    private final boolean open;
    private final State state;
    private final boolean read;
    private final Optional<Priority> priority;
    private final Optional<Integer> adminAssigneeId;
    private final Optional<String> teamAssigneeId;
    private final Optional<Tags> tags;
    private final Optional<ConversationRating> conversationRating;
    private final ConversationSource source;
    private final ConversationContacts contacts;
    private final ConversationTeammates teammates;
    private final Map<String, Object> customAttributes;
    private final Optional<ConversationFirstContactReply> firstContactReply;
    private final Optional<SlaApplied> slaApplied;
    private final Optional<ConversationStatistics> statistics;
    private final Optional<ConversationParts> conversationParts;
    private final Optional<LinkedObjectList> linkedObjects;
    private final Optional<Boolean> aiAgentParticipated;
    private final Optional<AiAgent> aiAgent;
    private final Map<String, Object> additionalProperties;

    private Conversation(Optional<String> type, String id, Optional<String> title, int createdAt, int updatedAt, Optional<Integer> waitingSince, Optional<Integer> snoozedUntil, boolean open, State state, boolean read, Optional<Priority> priority, Optional<Integer> adminAssigneeId, Optional<String> teamAssigneeId, Optional<Tags> tags, Optional<ConversationRating> conversationRating, ConversationSource source, ConversationContacts contacts, ConversationTeammates teammates, Map<String, Object> customAttributes, Optional<ConversationFirstContactReply> firstContactReply, Optional<SlaApplied> slaApplied, Optional<ConversationStatistics> statistics, Optional<ConversationParts> conversationParts, Optional<LinkedObjectList> linkedObjects, Optional<Boolean> aiAgentParticipated, Optional<AiAgent> aiAgent, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.title = title;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.waitingSince = waitingSince;
        this.snoozedUntil = snoozedUntil;
        this.open = open;
        this.state = state;
        this.read = read;
        this.priority = priority;
        this.adminAssigneeId = adminAssigneeId;
        this.teamAssigneeId = teamAssigneeId;
        this.tags = tags;
        this.conversationRating = conversationRating;
        this.source = source;
        this.contacts = contacts;
        this.teammates = teammates;
        this.customAttributes = customAttributes;
        this.firstContactReply = firstContactReply;
        this.slaApplied = slaApplied;
        this.statistics = statistics;
        this.conversationParts = conversationParts;
        this.linkedObjects = linkedObjects;
        this.aiAgentParticipated = aiAgentParticipated;
        this.aiAgent = aiAgent;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="waiting_since")
    public Optional<Integer> getWaitingSince() {
        return this.waitingSince;
    }

    @JsonProperty(value="snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return this.snoozedUntil;
    }

    @JsonProperty(value="open")
    public boolean getOpen() {
        return this.open;
    }

    @JsonProperty(value="state")
    public State getState() {
        return this.state;
    }

    @JsonProperty(value="read")
    public boolean getRead() {
        return this.read;
    }

    @JsonProperty(value="priority")
    public Optional<Priority> getPriority() {
        return this.priority;
    }

    @JsonProperty(value="admin_assignee_id")
    public Optional<Integer> getAdminAssigneeId() {
        return this.adminAssigneeId;
    }

    @JsonProperty(value="team_assignee_id")
    public Optional<String> getTeamAssigneeId() {
        return this.teamAssigneeId;
    }

    @JsonProperty(value="tags")
    public Optional<Tags> getTags() {
        return this.tags;
    }

    @JsonProperty(value="conversation_rating")
    public Optional<ConversationRating> getConversationRating() {
        return this.conversationRating;
    }

    @JsonProperty(value="source")
    public ConversationSource getSource() {
        return this.source;
    }

    @JsonProperty(value="contacts")
    public ConversationContacts getContacts() {
        return this.contacts;
    }

    @JsonProperty(value="teammates")
    public ConversationTeammates getTeammates() {
        return this.teammates;
    }

    @JsonProperty(value="custom_attributes")
    public Map<String, Object> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="first_contact_reply")
    public Optional<ConversationFirstContactReply> getFirstContactReply() {
        return this.firstContactReply;
    }

    @JsonProperty(value="sla_applied")
    public Optional<SlaApplied> getSlaApplied() {
        return this.slaApplied;
    }

    @JsonProperty(value="statistics")
    public Optional<ConversationStatistics> getStatistics() {
        return this.statistics;
    }

    @JsonProperty(value="conversation_parts")
    public Optional<ConversationParts> getConversationParts() {
        return this.conversationParts;
    }

    @JsonProperty(value="linked_objects")
    public Optional<LinkedObjectList> getLinkedObjects() {
        return this.linkedObjects;
    }

    @JsonProperty(value="ai_agent_participated")
    public Optional<Boolean> getAiAgentParticipated() {
        return this.aiAgentParticipated;
    }

    @JsonProperty(value="ai_agent")
    public Optional<AiAgent> getAiAgent() {
        return this.aiAgent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Conversation && this.equalTo((Conversation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Conversation other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.title.equals(other.title) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.waitingSince.equals(other.waitingSince) && this.snoozedUntil.equals(other.snoozedUntil) && this.open == other.open && this.state.equals(other.state) && this.read == other.read && this.priority.equals(other.priority) && this.adminAssigneeId.equals(other.adminAssigneeId) && this.teamAssigneeId.equals(other.teamAssigneeId) && this.tags.equals(other.tags) && this.conversationRating.equals(other.conversationRating) && this.source.equals(other.source) && this.contacts.equals(other.contacts) && this.teammates.equals(other.teammates) && this.customAttributes.equals(other.customAttributes) && this.firstContactReply.equals(other.firstContactReply) && this.slaApplied.equals(other.slaApplied) && this.statistics.equals(other.statistics) && this.conversationParts.equals(other.conversationParts) && this.linkedObjects.equals(other.linkedObjects) && this.aiAgentParticipated.equals(other.aiAgentParticipated) && this.aiAgent.equals(other.aiAgent);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.title, this.createdAt, this.updatedAt, this.waitingSince, this.snoozedUntil, this.open, this.state, this.read, this.priority, this.adminAssigneeId, this.teamAssigneeId, this.tags, this.conversationRating, this.source, this.contacts, this.teammates, this.customAttributes, this.firstContactReply, this.slaApplied, this.statistics, this.conversationParts, this.linkedObjects, this.aiAgentParticipated, this.aiAgent);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class State {
        public static final State SNOOZED = new State(Value.SNOOZED, "snoozed");
        public static final State CLOSED = new State(Value.CLOSED, "closed");
        public static final State OPEN = new State(Value.OPEN, "open");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SNOOZED: {
                    return visitor.visitSnoozed();
                }
                case CLOSED: {
                    return visitor.visitClosed();
                }
                case OPEN: {
                    return visitor.visitOpen();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "snoozed": {
                    return SNOOZED;
                }
                case "closed": {
                    return CLOSED;
                }
                case "open": {
                    return OPEN;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitOpen();

            public T visitClosed();

            public T visitSnoozed();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            OPEN,
            CLOSED,
            SNOOZED,
            UNKNOWN;

        }
    }

    public static final class Priority {
        public static final Priority PRIORITY = new Priority(Value.PRIORITY, "priority");
        public static final Priority NOT_PRIORITY = new Priority(Value.NOT_PRIORITY, "not_priority");
        private final Value value;
        private final String string;

        Priority(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Priority && this.string.equals(((Priority)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PRIORITY: {
                    return visitor.visitPriority();
                }
                case NOT_PRIORITY: {
                    return visitor.visitNotPriority();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Priority valueOf(String value) {
            switch (value) {
                case "priority": {
                    return PRIORITY;
                }
                case "not_priority": {
                    return NOT_PRIORITY;
                }
            }
            return new Priority(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPriority();

            public T visitNotPriority();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PRIORITY,
            NOT_PRIORITY,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    CreatedAtStage,
    UpdatedAtStage,
    OpenStage,
    StateStage,
    ReadStage,
    SourceStage,
    ContactsStage,
    TeammatesStage,
    _FinalStage {
        private String id;
        private int createdAt;
        private int updatedAt;
        private boolean open;
        private State state;
        private boolean read;
        private ConversationSource source;
        private ConversationContacts contacts;
        private ConversationTeammates teammates;
        private Optional<AiAgent> aiAgent = Optional.empty();
        private Optional<Boolean> aiAgentParticipated = Optional.empty();
        private Optional<LinkedObjectList> linkedObjects = Optional.empty();
        private Optional<ConversationParts> conversationParts = Optional.empty();
        private Optional<ConversationStatistics> statistics = Optional.empty();
        private Optional<SlaApplied> slaApplied = Optional.empty();
        private Optional<ConversationFirstContactReply> firstContactReply = Optional.empty();
        private Map<String, Object> customAttributes = new LinkedHashMap<String, Object>();
        private Optional<ConversationRating> conversationRating = Optional.empty();
        private Optional<Tags> tags = Optional.empty();
        private Optional<String> teamAssigneeId = Optional.empty();
        private Optional<Integer> adminAssigneeId = Optional.empty();
        private Optional<Priority> priority = Optional.empty();
        private Optional<Integer> snoozedUntil = Optional.empty();
        private Optional<Integer> waitingSince = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Conversation other) {
            this.type(other.getType());
            this.id(other.getId());
            this.title(other.getTitle());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.waitingSince(other.getWaitingSince());
            this.snoozedUntil(other.getSnoozedUntil());
            this.open(other.getOpen());
            this.state(other.getState());
            this.read(other.getRead());
            this.priority(other.getPriority());
            this.adminAssigneeId(other.getAdminAssigneeId());
            this.teamAssigneeId(other.getTeamAssigneeId());
            this.tags(other.getTags());
            this.conversationRating(other.getConversationRating());
            this.source(other.getSource());
            this.contacts(other.getContacts());
            this.teammates(other.getTeammates());
            this.customAttributes(other.getCustomAttributes());
            this.firstContactReply(other.getFirstContactReply());
            this.slaApplied(other.getSlaApplied());
            this.statistics(other.getStatistics());
            this.conversationParts(other.getConversationParts());
            this.linkedObjects(other.getLinkedObjects());
            this.aiAgentParticipated(other.getAiAgentParticipated());
            this.aiAgent(other.getAiAgent());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public OpenStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="open")
        public StateStage open(boolean open) {
            this.open = open;
            return this;
        }

        @Override
        @JsonSetter(value="state")
        public ReadStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="read")
        public SourceStage read(boolean read) {
            this.read = read;
            return this;
        }

        @Override
        @JsonSetter(value="source")
        public ContactsStage source(@NotNull ConversationSource source) {
            this.source = Objects.requireNonNull(source, "source must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contacts")
        public TeammatesStage contacts(@NotNull ConversationContacts contacts) {
            this.contacts = Objects.requireNonNull(contacts, "contacts must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="teammates")
        public _FinalStage teammates(@NotNull ConversationTeammates teammates) {
            this.teammates = Objects.requireNonNull(teammates, "teammates must not be null");
            return this;
        }

        @Override
        public _FinalStage aiAgent(AiAgent aiAgent) {
            this.aiAgent = Optional.ofNullable(aiAgent);
            return this;
        }

        @Override
        @JsonSetter(value="ai_agent", nulls=Nulls.SKIP)
        public _FinalStage aiAgent(Optional<AiAgent> aiAgent) {
            this.aiAgent = aiAgent;
            return this;
        }

        @Override
        public _FinalStage aiAgentParticipated(Boolean aiAgentParticipated) {
            this.aiAgentParticipated = Optional.ofNullable(aiAgentParticipated);
            return this;
        }

        @Override
        @JsonSetter(value="ai_agent_participated", nulls=Nulls.SKIP)
        public _FinalStage aiAgentParticipated(Optional<Boolean> aiAgentParticipated) {
            this.aiAgentParticipated = aiAgentParticipated;
            return this;
        }

        @Override
        public _FinalStage linkedObjects(LinkedObjectList linkedObjects) {
            this.linkedObjects = Optional.ofNullable(linkedObjects);
            return this;
        }

        @Override
        @JsonSetter(value="linked_objects", nulls=Nulls.SKIP)
        public _FinalStage linkedObjects(Optional<LinkedObjectList> linkedObjects) {
            this.linkedObjects = linkedObjects;
            return this;
        }

        @Override
        public _FinalStage conversationParts(ConversationParts conversationParts) {
            this.conversationParts = Optional.ofNullable(conversationParts);
            return this;
        }

        @Override
        @JsonSetter(value="conversation_parts", nulls=Nulls.SKIP)
        public _FinalStage conversationParts(Optional<ConversationParts> conversationParts) {
            this.conversationParts = conversationParts;
            return this;
        }

        @Override
        public _FinalStage statistics(ConversationStatistics statistics) {
            this.statistics = Optional.ofNullable(statistics);
            return this;
        }

        @Override
        @JsonSetter(value="statistics", nulls=Nulls.SKIP)
        public _FinalStage statistics(Optional<ConversationStatistics> statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public _FinalStage slaApplied(SlaApplied slaApplied) {
            this.slaApplied = Optional.ofNullable(slaApplied);
            return this;
        }

        @Override
        @JsonSetter(value="sla_applied", nulls=Nulls.SKIP)
        public _FinalStage slaApplied(Optional<SlaApplied> slaApplied) {
            this.slaApplied = slaApplied;
            return this;
        }

        @Override
        public _FinalStage firstContactReply(ConversationFirstContactReply firstContactReply) {
            this.firstContactReply = Optional.ofNullable(firstContactReply);
            return this;
        }

        @Override
        @JsonSetter(value="first_contact_reply", nulls=Nulls.SKIP)
        public _FinalStage firstContactReply(Optional<ConversationFirstContactReply> firstContactReply) {
            this.firstContactReply = firstContactReply;
            return this;
        }

        @Override
        public _FinalStage customAttributes(String key, Object value) {
            this.customAttributes.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllCustomAttributes(Map<String, Object> customAttributes) {
            this.customAttributes.putAll(customAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes.clear();
            this.customAttributes.putAll(customAttributes);
            return this;
        }

        @Override
        public _FinalStage conversationRating(ConversationRating conversationRating) {
            this.conversationRating = Optional.ofNullable(conversationRating);
            return this;
        }

        @Override
        @JsonSetter(value="conversation_rating", nulls=Nulls.SKIP)
        public _FinalStage conversationRating(Optional<ConversationRating> conversationRating) {
            this.conversationRating = conversationRating;
            return this;
        }

        @Override
        public _FinalStage tags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @Override
        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public _FinalStage tags(Optional<Tags> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public _FinalStage teamAssigneeId(String teamAssigneeId) {
            this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
            return this;
        }

        @Override
        @JsonSetter(value="team_assignee_id", nulls=Nulls.SKIP)
        public _FinalStage teamAssigneeId(Optional<String> teamAssigneeId) {
            this.teamAssigneeId = teamAssigneeId;
            return this;
        }

        @Override
        public _FinalStage adminAssigneeId(Integer adminAssigneeId) {
            this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
            return this;
        }

        @Override
        @JsonSetter(value="admin_assignee_id", nulls=Nulls.SKIP)
        public _FinalStage adminAssigneeId(Optional<Integer> adminAssigneeId) {
            this.adminAssigneeId = adminAssigneeId;
            return this;
        }

        @Override
        public _FinalStage priority(Priority priority) {
            this.priority = Optional.ofNullable(priority);
            return this;
        }

        @Override
        @JsonSetter(value="priority", nulls=Nulls.SKIP)
        public _FinalStage priority(Optional<Priority> priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public _FinalStage snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        @Override
        @JsonSetter(value="snoozed_until", nulls=Nulls.SKIP)
        public _FinalStage snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        @Override
        public _FinalStage waitingSince(Integer waitingSince) {
            this.waitingSince = Optional.ofNullable(waitingSince);
            return this;
        }

        @Override
        @JsonSetter(value="waiting_since", nulls=Nulls.SKIP)
        public _FinalStage waitingSince(Optional<Integer> waitingSince) {
            this.waitingSince = waitingSince;
            return this;
        }

        @Override
        public _FinalStage title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @Override
        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public _FinalStage title(Optional<String> title) {
            this.title = title;
            return this;
        }

        @Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @Override
        public Conversation build() {
            return new Conversation(this.type, this.id, this.title, this.createdAt, this.updatedAt, this.waitingSince, this.snoozedUntil, this.open, this.state, this.read, this.priority, this.adminAssigneeId, this.teamAssigneeId, this.tags, this.conversationRating, this.source, this.contacts, this.teammates, this.customAttributes, this.firstContactReply, this.slaApplied, this.statistics, this.conversationParts, this.linkedObjects, this.aiAgentParticipated, this.aiAgent, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Conversation build();

        public _FinalStage type(Optional<String> var1);

        public _FinalStage type(String var1);

        public _FinalStage title(Optional<String> var1);

        public _FinalStage title(String var1);

        public _FinalStage waitingSince(Optional<Integer> var1);

        public _FinalStage waitingSince(Integer var1);

        public _FinalStage snoozedUntil(Optional<Integer> var1);

        public _FinalStage snoozedUntil(Integer var1);

        public _FinalStage priority(Optional<Priority> var1);

        public _FinalStage priority(Priority var1);

        public _FinalStage adminAssigneeId(Optional<Integer> var1);

        public _FinalStage adminAssigneeId(Integer var1);

        public _FinalStage teamAssigneeId(Optional<String> var1);

        public _FinalStage teamAssigneeId(String var1);

        public _FinalStage tags(Optional<Tags> var1);

        public _FinalStage tags(Tags var1);

        public _FinalStage conversationRating(Optional<ConversationRating> var1);

        public _FinalStage conversationRating(ConversationRating var1);

        public _FinalStage customAttributes(Map<String, Object> var1);

        public _FinalStage putAllCustomAttributes(Map<String, Object> var1);

        public _FinalStage customAttributes(String var1, Object var2);

        public _FinalStage firstContactReply(Optional<ConversationFirstContactReply> var1);

        public _FinalStage firstContactReply(ConversationFirstContactReply var1);

        public _FinalStage slaApplied(Optional<SlaApplied> var1);

        public _FinalStage slaApplied(SlaApplied var1);

        public _FinalStage statistics(Optional<ConversationStatistics> var1);

        public _FinalStage statistics(ConversationStatistics var1);

        public _FinalStage conversationParts(Optional<ConversationParts> var1);

        public _FinalStage conversationParts(ConversationParts var1);

        public _FinalStage linkedObjects(Optional<LinkedObjectList> var1);

        public _FinalStage linkedObjects(LinkedObjectList var1);

        public _FinalStage aiAgentParticipated(Optional<Boolean> var1);

        public _FinalStage aiAgentParticipated(Boolean var1);

        public _FinalStage aiAgent(Optional<AiAgent> var1);

        public _FinalStage aiAgent(AiAgent var1);
    }

    public static interface TeammatesStage {
        public _FinalStage teammates(@NotNull ConversationTeammates var1);
    }

    public static interface ContactsStage {
        public TeammatesStage contacts(@NotNull ConversationContacts var1);
    }

    public static interface SourceStage {
        public ContactsStage source(@NotNull ConversationSource var1);
    }

    public static interface ReadStage {
        public SourceStage read(boolean var1);
    }

    public static interface StateStage {
        public ReadStage state(@NotNull State var1);
    }

    public static interface OpenStage {
        public StateStage open(boolean var1);
    }

    public static interface UpdatedAtStage {
        public OpenStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface IdStage {
        public CreatedAtStage id(@NotNull String var1);

        public Builder from(Conversation var1);
    }
}

