/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.GroupTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Collection {
    private final String id;
    private final String workspaceId;
    private final String name;
    private final Optional<String> description;
    private final int createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<String> url;
    private final Optional<String> icon;
    private final int order;
    private final String defaultLocale;
    private final Optional<GroupTranslatedContent> translatedContent;
    private final Optional<String> parentId;
    private final Optional<Integer> helpCenterId;
    private final Map<String, Object> additionalProperties;

    private Collection(String id, String workspaceId, String name, Optional<String> description, int createdAt, Optional<Integer> updatedAt, Optional<String> url, Optional<String> icon, int order, String defaultLocale, Optional<GroupTranslatedContent> translatedContent, Optional<String> parentId, Optional<Integer> helpCenterId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.name = name;
        this.description = description;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.icon = icon;
        this.order = order;
        this.defaultLocale = defaultLocale;
        this.translatedContent = translatedContent;
        this.parentId = parentId;
        this.helpCenterId = helpCenterId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="order")
    public int getOrder() {
        return this.order;
    }

    @JsonProperty(value="default_locale")
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    @JsonProperty(value="translated_content")
    public Optional<GroupTranslatedContent> getTranslatedContent() {
        return this.translatedContent;
    }

    @JsonProperty(value="parent_id")
    public Optional<String> getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="help_center_id")
    public Optional<Integer> getHelpCenterId() {
        return this.helpCenterId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Collection && this.equalTo((Collection)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Collection other) {
        return this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.name.equals(other.name) && this.description.equals(other.description) && this.createdAt == other.createdAt && this.updatedAt.equals(other.updatedAt) && this.url.equals(other.url) && this.icon.equals(other.icon) && this.order == other.order && this.defaultLocale.equals(other.defaultLocale) && this.translatedContent.equals(other.translatedContent) && this.parentId.equals(other.parentId) && this.helpCenterId.equals(other.helpCenterId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.workspaceId, this.name, this.description, this.createdAt, this.updatedAt, this.url, this.icon, this.order, this.defaultLocale, this.translatedContent, this.parentId, this.helpCenterId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    WorkspaceIdStage,
    NameStage,
    CreatedAtStage,
    OrderStage,
    DefaultLocaleStage,
    _FinalStage {
        private String id;
        private String workspaceId;
        private String name;
        private int createdAt;
        private int order;
        private String defaultLocale;
        private Optional<Integer> helpCenterId = Optional.empty();
        private Optional<String> parentId = Optional.empty();
        private Optional<GroupTranslatedContent> translatedContent = Optional.empty();
        private Optional<String> icon = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Collection other) {
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.url(other.getUrl());
            this.icon(other.getIcon());
            this.order(other.getOrder());
            this.defaultLocale(other.getDefaultLocale());
            this.translatedContent(other.getTranslatedContent());
            this.parentId(other.getParentId());
            this.helpCenterId(other.getHelpCenterId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public NameStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CreatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public OrderStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="order")
        public DefaultLocaleStage order(int order) {
            this.order = order;
            return this;
        }

        @Override
        @JsonSetter(value="default_locale")
        public _FinalStage defaultLocale(@NotNull String defaultLocale) {
            this.defaultLocale = Objects.requireNonNull(defaultLocale, "defaultLocale must not be null");
            return this;
        }

        @Override
        public _FinalStage helpCenterId(Integer helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        @Override
        @JsonSetter(value="help_center_id", nulls=Nulls.SKIP)
        public _FinalStage helpCenterId(Optional<Integer> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        @Override
        public _FinalStage parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        @Override
        @JsonSetter(value="parent_id", nulls=Nulls.SKIP)
        public _FinalStage parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        @Override
        public _FinalStage translatedContent(GroupTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        @Override
        @JsonSetter(value="translated_content", nulls=Nulls.SKIP)
        public _FinalStage translatedContent(Optional<GroupTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        @Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @Override
        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public Collection build() {
            return new Collection(this.id, this.workspaceId, this.name, this.description, this.createdAt, this.updatedAt, this.url, this.icon, this.order, this.defaultLocale, this.translatedContent, this.parentId, this.helpCenterId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Collection build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage icon(Optional<String> var1);

        public _FinalStage icon(String var1);

        public _FinalStage translatedContent(Optional<GroupTranslatedContent> var1);

        public _FinalStage translatedContent(GroupTranslatedContent var1);

        public _FinalStage parentId(Optional<String> var1);

        public _FinalStage parentId(String var1);

        public _FinalStage helpCenterId(Optional<Integer> var1);

        public _FinalStage helpCenterId(Integer var1);
    }

    public static interface DefaultLocaleStage {
        public _FinalStage defaultLocale(@NotNull String var1);
    }

    public static interface OrderStage {
        public DefaultLocaleStage order(int var1);
    }

    public static interface CreatedAtStage {
        public OrderStage createdAt(int var1);
    }

    public static interface NameStage {
        public CreatedAtStage name(@NotNull String var1);
    }

    public static interface WorkspaceIdStage {
        public NameStage workspaceId(@NotNull String var1);
    }

    public static interface IdStage {
        public WorkspaceIdStage id(@NotNull String var1);

        public Builder from(Collection var1);
    }
}

