/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.teams.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.AdminPriorityLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Team {
    private final String id;
    private final String name;
    private final List<Integer> adminIds;
    private final Optional<AdminPriorityLevel> adminPriorityLevel;
    private final Map<String, Object> additionalProperties;

    private Team(String id, String name, List<Integer> adminIds, Optional<AdminPriorityLevel> adminPriorityLevel, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.adminIds = adminIds;
        this.adminPriorityLevel = adminPriorityLevel;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "team";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="admin_ids")
    public List<Integer> getAdminIds() {
        return this.adminIds;
    }

    @JsonProperty(value="admin_priority_level")
    public Optional<AdminPriorityLevel> getAdminPriorityLevel() {
        return this.adminPriorityLevel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Team && this.equalTo((Team)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Team other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.adminIds.equals(other.adminIds) && this.adminPriorityLevel.equals(other.adminPriorityLevel);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.adminIds, this.adminPriorityLevel);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<AdminPriorityLevel> adminPriorityLevel = Optional.empty();
        private List<Integer> adminIds = new ArrayList<Integer>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Team other) {
            this.id(other.getId());
            this.name(other.getName());
            this.adminIds(other.getAdminIds());
            this.adminPriorityLevel(other.getAdminPriorityLevel());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage adminPriorityLevel(AdminPriorityLevel adminPriorityLevel) {
            this.adminPriorityLevel = Optional.ofNullable(adminPriorityLevel);
            return this;
        }

        @Override
        @JsonSetter(value="admin_priority_level", nulls=Nulls.SKIP)
        public _FinalStage adminPriorityLevel(Optional<AdminPriorityLevel> adminPriorityLevel) {
            this.adminPriorityLevel = adminPriorityLevel;
            return this;
        }

        @Override
        public _FinalStage addAllAdminIds(List<Integer> adminIds) {
            this.adminIds.addAll(adminIds);
            return this;
        }

        @Override
        public _FinalStage addAdminIds(Integer adminIds) {
            this.adminIds.add(adminIds);
            return this;
        }

        @Override
        @JsonSetter(value="admin_ids", nulls=Nulls.SKIP)
        public _FinalStage adminIds(List<Integer> adminIds) {
            this.adminIds.clear();
            this.adminIds.addAll(adminIds);
            return this;
        }

        @Override
        public Team build() {
            return new Team(this.id, this.name, this.adminIds, this.adminPriorityLevel, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Team build();

        public _FinalStage adminIds(List<Integer> var1);

        public _FinalStage addAdminIds(Integer var1);

        public _FinalStage addAllAdminIds(List<Integer> var1);

        public _FinalStage adminPriorityLevel(Optional<AdminPriorityLevel> var1);

        public _FinalStage adminPriorityLevel(AdminPriorityLevel var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Team var1);
    }
}

