/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListAllCompaniesRequest {
    private final Optional<Integer> page;
    private final Optional<Integer> perPage;
    private final Optional<String> order;
    private final Map<String, Object> additionalProperties;

    private ListAllCompaniesRequest(Optional<Integer> page, Optional<Integer> perPage, Optional<String> order, Map<String, Object> additionalProperties) {
        this.page = page;
        this.perPage = perPage;
        this.order = order;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="per_page")
    public Optional<Integer> getPerPage() {
        return this.perPage;
    }

    @JsonProperty(value="order")
    public Optional<String> getOrder() {
        return this.order;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListAllCompaniesRequest && this.equalTo((ListAllCompaniesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListAllCompaniesRequest other) {
        return this.page.equals(other.page) && this.perPage.equals(other.perPage) && this.order.equals(other.order);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.perPage, this.order);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> perPage = Optional.empty();
        private Optional<String> order = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListAllCompaniesRequest other) {
            this.page(other.getPage());
            this.perPage(other.getPerPage());
            this.order(other.getOrder());
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="per_page", nulls=Nulls.SKIP)
        public Builder perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<String> order) {
            this.order = order;
            return this;
        }

        public Builder order(String order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        public ListAllCompaniesRequest build() {
            return new ListAllCompaniesRequest(this.page, this.perPage, this.order, this.additionalProperties);
        }
    }
}

