/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.subscriptiontypes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.errors.NotFoundError;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.subscriptiontypes.requests.AttachSubscriptionTypeToContactRequest;
import com.intercom.api.resources.unstable.subscriptiontypes.requests.DetachSubscriptionTypeToContactRequest;
import com.intercom.api.resources.unstable.subscriptiontypes.types.SubscriptionType;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.SubscriptionTypeList;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawSubscriptionTypesClient {
    protected final ClientOptions clientOptions;

    public RawSubscriptionTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public IntercomHttpResponse<SubscriptionType> attachSubscriptionTypeToContact(AttachSubscriptionTypeToContactRequest request) {
        return this.attachSubscriptionTypeToContact(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<SubscriptionType> attachSubscriptionTypeToContact(AttachSubscriptionTypeToContactRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contacts").addPathSegment(request.getContactId()).addPathSegments("subscriptions").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<SubscriptionType> intercomHttpResponse = new IntercomHttpResponse<SubscriptionType>((SubscriptionType)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SubscriptionType.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<SubscriptionType> detachSubscriptionTypeToContact(DetachSubscriptionTypeToContactRequest request) {
        return this.detachSubscriptionTypeToContact(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<SubscriptionType> detachSubscriptionTypeToContact(DetachSubscriptionTypeToContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contacts").addPathSegment(request.getContactId()).addPathSegments("subscriptions").addPathSegment(request.getId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<SubscriptionType> intercomHttpResponse = new IntercomHttpResponse<SubscriptionType>((SubscriptionType)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SubscriptionType.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<SubscriptionTypeList> listSubscriptionTypes() {
        return this.listSubscriptionTypes(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<SubscriptionTypeList> listSubscriptionTypes(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("subscription_types").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<SubscriptionTypeList> intercomHttpResponse = new IntercomHttpResponse<SubscriptionTypeList>((SubscriptionTypeList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SubscriptionTypeList.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 401) throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}

