/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.PartAttachment;
import com.intercom.api.resources.unstable.types.Reference;
import com.intercom.api.resources.unstable.types.TicketPartAuthor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketPart {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> partType;
    private final Optional<String> body;
    private final Optional<PreviousTicketState> previousTicketState;
    private final Optional<TicketState> ticketState;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<Reference> assignedTo;
    private final Optional<TicketPartAuthor> author;
    private final Optional<List<PartAttachment>> attachments;
    private final Optional<String> externalId;
    private final Optional<Boolean> redacted;
    private final Optional<String> appPackageCode;
    private final Optional<UpdatedAttributeData> updatedAttributeData;
    private final Map<String, Object> additionalProperties;

    private TicketPart(Optional<String> type, Optional<String> id, Optional<String> partType, Optional<String> body, Optional<PreviousTicketState> previousTicketState, Optional<TicketState> ticketState, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<Reference> assignedTo, Optional<TicketPartAuthor> author, Optional<List<PartAttachment>> attachments, Optional<String> externalId, Optional<Boolean> redacted, Optional<String> appPackageCode, Optional<UpdatedAttributeData> updatedAttributeData, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.previousTicketState = previousTicketState;
        this.ticketState = ticketState;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.assignedTo = assignedTo;
        this.author = author;
        this.attachments = attachments;
        this.externalId = externalId;
        this.redacted = redacted;
        this.appPackageCode = appPackageCode;
        this.updatedAttributeData = updatedAttributeData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="part_type")
    public Optional<String> getPartType() {
        return this.partType;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="previous_ticket_state")
    public Optional<PreviousTicketState> getPreviousTicketState() {
        return this.previousTicketState;
    }

    @JsonProperty(value="ticket_state")
    public Optional<TicketState> getTicketState() {
        return this.ticketState;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="assigned_to")
    public Optional<Reference> getAssignedTo() {
        return this.assignedTo;
    }

    @JsonProperty(value="author")
    public Optional<TicketPartAuthor> getAuthor() {
        return this.author;
    }

    @JsonProperty(value="attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="redacted")
    public Optional<Boolean> getRedacted() {
        return this.redacted;
    }

    @JsonProperty(value="app_package_code")
    public Optional<String> getAppPackageCode() {
        return this.appPackageCode;
    }

    @JsonProperty(value="updated_attribute_data")
    public Optional<UpdatedAttributeData> getUpdatedAttributeData() {
        return this.updatedAttributeData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketPart && this.equalTo((TicketPart)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketPart other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.partType.equals(other.partType) && this.body.equals(other.body) && this.previousTicketState.equals(other.previousTicketState) && this.ticketState.equals(other.ticketState) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.assignedTo.equals(other.assignedTo) && this.author.equals(other.author) && this.attachments.equals(other.attachments) && this.externalId.equals(other.externalId) && this.redacted.equals(other.redacted) && this.appPackageCode.equals(other.appPackageCode) && this.updatedAttributeData.equals(other.updatedAttributeData);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.partType, this.body, this.previousTicketState, this.ticketState, this.createdAt, this.updatedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted, this.appPackageCode, this.updatedAttributeData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class PreviousTicketState {
        public static final PreviousTicketState IN_PROGRESS = new PreviousTicketState(Value.IN_PROGRESS, "in_progress");
        public static final PreviousTicketState SUBMITTED = new PreviousTicketState(Value.SUBMITTED, "submitted");
        public static final PreviousTicketState RESOLVED = new PreviousTicketState(Value.RESOLVED, "resolved");
        public static final PreviousTicketState WAITING_ON_CUSTOMER = new PreviousTicketState(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");
        private final Value value;
        private final String string;

        PreviousTicketState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PreviousTicketState && this.string.equals(((PreviousTicketState)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case IN_PROGRESS: {
                    return visitor.visitInProgress();
                }
                case SUBMITTED: {
                    return visitor.visitSubmitted();
                }
                case RESOLVED: {
                    return visitor.visitResolved();
                }
                case WAITING_ON_CUSTOMER: {
                    return visitor.visitWaitingOnCustomer();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static PreviousTicketState valueOf(String value) {
            switch (value) {
                case "in_progress": {
                    return IN_PROGRESS;
                }
                case "submitted": {
                    return SUBMITTED;
                }
                case "resolved": {
                    return RESOLVED;
                }
                case "waiting_on_customer": {
                    return WAITING_ON_CUSTOMER;
                }
            }
            return new PreviousTicketState(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitSubmitted();

            public T visitInProgress();

            public T visitWaitingOnCustomer();

            public T visitResolved();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            SUBMITTED,
            IN_PROGRESS,
            WAITING_ON_CUSTOMER,
            RESOLVED,
            UNKNOWN;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class UpdatedAttributeData {
        private final Attribute attribute;
        private final Value value;
        private final Map<String, Object> additionalProperties;

        private UpdatedAttributeData(Attribute attribute, Value value, Map<String, Object> additionalProperties) {
            this.attribute = attribute;
            this.value = value;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="attribute")
        public Attribute getAttribute() {
            return this.attribute;
        }

        @JsonProperty(value="value")
        public Value getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof UpdatedAttributeData && this.equalTo((UpdatedAttributeData)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(UpdatedAttributeData other) {
            return this.attribute.equals(other.attribute) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.attribute, this.value);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static AttributeStage builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class Attribute {
            private final String id;
            private final String label;
            private final Map<String, Object> additionalProperties;

            private Attribute(String id, String label, Map<String, Object> additionalProperties) {
                this.id = id;
                this.label = label;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="type")
            public String getType() {
                return "attribute";
            }

            @JsonProperty(value="id")
            public String getId() {
                return this.id;
            }

            @JsonProperty(value="label")
            public String getLabel() {
                return this.label;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof Attribute && this.equalTo((Attribute)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Attribute other) {
                return this.id.equals(other.id) && this.label.equals(other.label);
            }

            public int hashCode() {
                return Objects.hash(this.id, this.label);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements IdStage,
            LabelStage,
            _FinalStage {
                private String id;
                private String label;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(Attribute other) {
                    this.id(other.getId());
                    this.label(other.getLabel());
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public LabelStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @Override
                @JsonSetter(value="label")
                public _FinalStage label(@NotNull String label) {
                    this.label = Objects.requireNonNull(label, "label must not be null");
                    return this;
                }

                @Override
                public Attribute build() {
                    return new Attribute(this.id, this.label, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public Attribute build();
            }

            public static interface LabelStage {
                public _FinalStage label(@NotNull String var1);
            }

            public static interface IdStage {
                public LabelStage id(@NotNull String var1);

                public Builder from(Attribute var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class Value {
            private final Id id;
            private final Label label;
            private final Map<String, Object> additionalProperties;

            private Value(Id id, Label label, Map<String, Object> additionalProperties) {
                this.id = id;
                this.label = label;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="type")
            public String getType() {
                return "value";
            }

            @JsonProperty(value="id")
            public Id getId() {
                return this.id;
            }

            @JsonProperty(value="label")
            public Label getLabel() {
                return this.label;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof Value && this.equalTo((Value)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Value other) {
                return this.id.equals(other.id) && this.label.equals(other.label);
            }

            public int hashCode() {
                return Objects.hash(this.id, this.label);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            @JsonDeserialize(using=Deserializer.class)
            public static final class Id {
                private final Object value;
                private final int type;

                private Id(Object value, int type) {
                    this.value = value;
                    this.type = type;
                }

                @JsonValue
                public Object get() {
                    return this.value;
                }

                public <T> T visit(Visitor<T> visitor) {
                    if (this.type == 0) {
                        return visitor.visit((Optional)this.value);
                    }
                    if (this.type == 1) {
                        return visitor.visit((List)this.value);
                    }
                    throw new IllegalStateException("Failed to visit value. This should never happen.");
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    return other instanceof Id && this.equalTo((Id)other);
                }

                private boolean equalTo(Id other) {
                    return this.value.equals(other.value);
                }

                public int hashCode() {
                    return Objects.hash(this.value);
                }

                public String toString() {
                    return this.value.toString();
                }

                public static Id of(Optional<String> value) {
                    return new Id(value, 0);
                }

                public static Id of(List<Integer> value) {
                    return new Id(value, 1);
                }

                static final class Deserializer
                extends StdDeserializer<Id> {
                    Deserializer() {
                        super(Id.class);
                    }

                    public Id deserialize(JsonParser p, DeserializationContext context) throws IOException {
                        Object value = p.readValueAs(Object.class);
                        try {
                            return Id.of((Optional)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Optional<String>>(){}));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            try {
                                return Id.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<Integer>>(){}));
                            }
                            catch (IllegalArgumentException illegalArgumentException2) {
                                throw new JsonParseException(p, "Failed to deserialize");
                            }
                        }
                    }
                }

                public static interface Visitor<T> {
                    public T visit(Optional<String> var1);

                    public T visit(List<Integer> var1);
                }
            }

            @JsonDeserialize(using=Deserializer.class)
            public static final class Label {
                private final Object value;
                private final int type;

                private Label(Object value, int type) {
                    this.value = value;
                    this.type = type;
                }

                @JsonValue
                public Object get() {
                    return this.value;
                }

                public <T> T visit(Visitor<T> visitor) {
                    if (this.type == 0) {
                        return visitor.visit((String)this.value);
                    }
                    if (this.type == 1) {
                        return visitor.visit((List)this.value);
                    }
                    throw new IllegalStateException("Failed to visit value. This should never happen.");
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    return other instanceof Label && this.equalTo((Label)other);
                }

                private boolean equalTo(Label other) {
                    return this.value.equals(other.value);
                }

                public int hashCode() {
                    return Objects.hash(this.value);
                }

                public String toString() {
                    return this.value.toString();
                }

                public static Label of(String value) {
                    return new Label(value, 0);
                }

                public static Label of(List<String> value) {
                    return new Label(value, 1);
                }

                static final class Deserializer
                extends StdDeserializer<Label> {
                    Deserializer() {
                        super(Label.class);
                    }

                    public Label deserialize(JsonParser p, DeserializationContext context) throws IOException {
                        Object value = p.readValueAs(Object.class);
                        try {
                            return Label.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            try {
                                return Label.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<String>>(){}));
                            }
                            catch (IllegalArgumentException illegalArgumentException2) {
                                throw new JsonParseException(p, "Failed to deserialize");
                            }
                        }
                    }
                }

                public static interface Visitor<T> {
                    public T visit(String var1);

                    public T visit(List<String> var1);
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements IdStage,
            LabelStage,
            _FinalStage {
                private Id id;
                private Label label;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(Value other) {
                    this.id(other.getId());
                    this.label(other.getLabel());
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public LabelStage id(@NotNull Id id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @Override
                @JsonSetter(value="label")
                public _FinalStage label(@NotNull Label label) {
                    this.label = Objects.requireNonNull(label, "label must not be null");
                    return this;
                }

                @Override
                public Value build() {
                    return new Value(this.id, this.label, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public Value build();
            }

            public static interface LabelStage {
                public _FinalStage label(@NotNull Label var1);
            }

            public static interface IdStage {
                public LabelStage id(@NotNull Id var1);

                public Builder from(Value var1);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements AttributeStage,
        ValueStage,
        _FinalStage {
            private Attribute attribute;
            private Value value;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(UpdatedAttributeData other) {
                this.attribute(other.getAttribute());
                this.value(other.getValue());
                return this;
            }

            @Override
            @JsonSetter(value="attribute")
            public ValueStage attribute(@NotNull Attribute attribute) {
                this.attribute = Objects.requireNonNull(attribute, "attribute must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="value")
            public _FinalStage value(@NotNull Value value) {
                this.value = Objects.requireNonNull(value, "value must not be null");
                return this;
            }

            @Override
            public UpdatedAttributeData build() {
                return new UpdatedAttributeData(this.attribute, this.value, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public UpdatedAttributeData build();
        }

        public static interface ValueStage {
            public _FinalStage value(@NotNull Value var1);
        }

        public static interface AttributeStage {
            public ValueStage attribute(@NotNull Attribute var1);

            public Builder from(UpdatedAttributeData var1);
        }
    }

    public static final class TicketState {
        public static final TicketState IN_PROGRESS = new TicketState(Value.IN_PROGRESS, "in_progress");
        public static final TicketState SUBMITTED = new TicketState(Value.SUBMITTED, "submitted");
        public static final TicketState RESOLVED = new TicketState(Value.RESOLVED, "resolved");
        public static final TicketState WAITING_ON_CUSTOMER = new TicketState(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");
        private final Value value;
        private final String string;

        TicketState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof TicketState && this.string.equals(((TicketState)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case IN_PROGRESS: {
                    return visitor.visitInProgress();
                }
                case SUBMITTED: {
                    return visitor.visitSubmitted();
                }
                case RESOLVED: {
                    return visitor.visitResolved();
                }
                case WAITING_ON_CUSTOMER: {
                    return visitor.visitWaitingOnCustomer();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static TicketState valueOf(String value) {
            switch (value) {
                case "in_progress": {
                    return IN_PROGRESS;
                }
                case "submitted": {
                    return SUBMITTED;
                }
                case "resolved": {
                    return RESOLVED;
                }
                case "waiting_on_customer": {
                    return WAITING_ON_CUSTOMER;
                }
            }
            return new TicketState(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitSubmitted();

            public T visitInProgress();

            public T visitWaitingOnCustomer();

            public T visitResolved();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            SUBMITTED,
            IN_PROGRESS,
            WAITING_ON_CUSTOMER,
            RESOLVED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> partType = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<PreviousTicketState> previousTicketState = Optional.empty();
        private Optional<TicketState> ticketState = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<Reference> assignedTo = Optional.empty();
        private Optional<TicketPartAuthor> author = Optional.empty();
        private Optional<List<PartAttachment>> attachments = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<Boolean> redacted = Optional.empty();
        private Optional<String> appPackageCode = Optional.empty();
        private Optional<UpdatedAttributeData> updatedAttributeData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TicketPart other) {
            this.type(other.getType());
            this.id(other.getId());
            this.partType(other.getPartType());
            this.body(other.getBody());
            this.previousTicketState(other.getPreviousTicketState());
            this.ticketState(other.getTicketState());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.assignedTo(other.getAssignedTo());
            this.author(other.getAuthor());
            this.attachments(other.getAttachments());
            this.externalId(other.getExternalId());
            this.redacted(other.getRedacted());
            this.appPackageCode(other.getAppPackageCode());
            this.updatedAttributeData(other.getUpdatedAttributeData());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="part_type", nulls=Nulls.SKIP)
        public Builder partType(Optional<String> partType) {
            this.partType = partType;
            return this;
        }

        public Builder partType(String partType) {
            this.partType = Optional.ofNullable(partType);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @JsonSetter(value="previous_ticket_state", nulls=Nulls.SKIP)
        public Builder previousTicketState(Optional<PreviousTicketState> previousTicketState) {
            this.previousTicketState = previousTicketState;
            return this;
        }

        public Builder previousTicketState(PreviousTicketState previousTicketState) {
            this.previousTicketState = Optional.ofNullable(previousTicketState);
            return this;
        }

        @JsonSetter(value="ticket_state", nulls=Nulls.SKIP)
        public Builder ticketState(Optional<TicketState> ticketState) {
            this.ticketState = ticketState;
            return this;
        }

        public Builder ticketState(TicketState ticketState) {
            this.ticketState = Optional.ofNullable(ticketState);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="assigned_to", nulls=Nulls.SKIP)
        public Builder assignedTo(Optional<Reference> assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        public Builder assignedTo(Reference assignedTo) {
            this.assignedTo = Optional.ofNullable(assignedTo);
            return this;
        }

        @JsonSetter(value="author", nulls=Nulls.SKIP)
        public Builder author(Optional<TicketPartAuthor> author) {
            this.author = author;
            return this;
        }

        public Builder author(TicketPartAuthor author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public Builder attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public Builder externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @JsonSetter(value="redacted", nulls=Nulls.SKIP)
        public Builder redacted(Optional<Boolean> redacted) {
            this.redacted = redacted;
            return this;
        }

        public Builder redacted(Boolean redacted) {
            this.redacted = Optional.ofNullable(redacted);
            return this;
        }

        @JsonSetter(value="app_package_code", nulls=Nulls.SKIP)
        public Builder appPackageCode(Optional<String> appPackageCode) {
            this.appPackageCode = appPackageCode;
            return this;
        }

        public Builder appPackageCode(String appPackageCode) {
            this.appPackageCode = Optional.ofNullable(appPackageCode);
            return this;
        }

        @JsonSetter(value="updated_attribute_data", nulls=Nulls.SKIP)
        public Builder updatedAttributeData(Optional<UpdatedAttributeData> updatedAttributeData) {
            this.updatedAttributeData = updatedAttributeData;
            return this;
        }

        public Builder updatedAttributeData(UpdatedAttributeData updatedAttributeData) {
            this.updatedAttributeData = Optional.ofNullable(updatedAttributeData);
            return this;
        }

        public TicketPart build() {
            return new TicketPart(this.type, this.id, this.partType, this.body, this.previousTicketState, this.ticketState, this.createdAt, this.updatedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted, this.appPackageCode, this.updatedAttributeData, this.additionalProperties);
        }
    }
}

