/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.CustomChannelContact;
import com.intercom.api.resources.unstable.types.ICustomChannelBaseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomChannelBaseEvent
implements ICustomChannelBaseEvent {
    private final String eventId;
    private final String externalConversationId;
    private final CustomChannelContact contact;
    private final Map<String, Object> additionalProperties;

    private CustomChannelBaseEvent(String eventId, String externalConversationId, CustomChannelContact contact, Map<String, Object> additionalProperties) {
        this.eventId = eventId;
        this.externalConversationId = externalConversationId;
        this.contact = contact;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="event_id")
    public String getEventId() {
        return this.eventId;
    }

    @Override
    @JsonProperty(value="external_conversation_id")
    public String getExternalConversationId() {
        return this.externalConversationId;
    }

    @Override
    @JsonProperty(value="contact")
    public CustomChannelContact getContact() {
        return this.contact;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomChannelBaseEvent && this.equalTo((CustomChannelBaseEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomChannelBaseEvent other) {
        return this.eventId.equals(other.eventId) && this.externalConversationId.equals(other.externalConversationId) && this.contact.equals(other.contact);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.externalConversationId, this.contact);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EventIdStage,
    ExternalConversationIdStage,
    ContactStage,
    _FinalStage {
        private String eventId;
        private String externalConversationId;
        private CustomChannelContact contact;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CustomChannelBaseEvent other) {
            this.eventId(other.getEventId());
            this.externalConversationId(other.getExternalConversationId());
            this.contact(other.getContact());
            return this;
        }

        @Override
        @JsonSetter(value="event_id")
        public ExternalConversationIdStage eventId(@NotNull String eventId) {
            this.eventId = Objects.requireNonNull(eventId, "eventId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_conversation_id")
        public ContactStage externalConversationId(@NotNull String externalConversationId) {
            this.externalConversationId = Objects.requireNonNull(externalConversationId, "externalConversationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contact")
        public _FinalStage contact(@NotNull CustomChannelContact contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @Override
        public CustomChannelBaseEvent build() {
            return new CustomChannelBaseEvent(this.eventId, this.externalConversationId, this.contact, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CustomChannelBaseEvent build();
    }

    public static interface ContactStage {
        public _FinalStage contact(@NotNull CustomChannelContact var1);
    }

    public static interface ExternalConversationIdStage {
        public ContactStage externalConversationId(@NotNull String var1);
    }

    public static interface EventIdStage {
        public ExternalConversationIdStage eventId(@NotNull String var1);

        public Builder from(CustomChannelBaseEvent var1);
    }
}

