/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateTicketTypeRequestBody {
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<Category> category;
    private final Optional<String> icon;
    private final Optional<Boolean> archived;
    private final Optional<Boolean> isInternal;
    private final Map<String, Object> additionalProperties;

    private UpdateTicketTypeRequestBody(Optional<String> name, Optional<String> description, Optional<Category> category, Optional<String> icon, Optional<Boolean> archived, Optional<Boolean> isInternal, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.category = category;
        this.icon = icon;
        this.archived = archived;
        this.isInternal = isInternal;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="category")
    public Optional<Category> getCategory() {
        return this.category;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="archived")
    public Optional<Boolean> getArchived() {
        return this.archived;
    }

    @JsonProperty(value="is_internal")
    public Optional<Boolean> getIsInternal() {
        return this.isInternal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateTicketTypeRequestBody && this.equalTo((UpdateTicketTypeRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTicketTypeRequestBody other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.category.equals(other.category) && this.icon.equals(other.icon) && this.archived.equals(other.archived) && this.isInternal.equals(other.isInternal);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.category, this.icon, this.archived, this.isInternal);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");
        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");
        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");
        private final Value value;
        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Category && this.string.equals(((Category)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case BACK_OFFICE: {
                    return visitor.visitBackOffice();
                }
                case CUSTOMER: {
                    return visitor.visitCustomer();
                }
                case TRACKER: {
                    return visitor.visitTracker();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office": {
                    return BACK_OFFICE;
                }
                case "Customer": {
                    return CUSTOMER;
                }
                case "Tracker": {
                    return TRACKER;
                }
            }
            return new Category(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitCustomer();

            public T visitBackOffice();

            public T visitTracker();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CUSTOMER,
            BACK_OFFICE,
            TRACKER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Category> category = Optional.empty();
        private Optional<String> icon = Optional.empty();
        private Optional<Boolean> archived = Optional.empty();
        private Optional<Boolean> isInternal = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateTicketTypeRequestBody other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.category(other.getCategory());
            this.icon(other.getIcon());
            this.archived(other.getArchived());
            this.isInternal(other.getIsInternal());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public Builder category(Optional<Category> category) {
            this.category = category;
            return this;
        }

        public Builder category(Category category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public Builder icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @JsonSetter(value="archived", nulls=Nulls.SKIP)
        public Builder archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @JsonSetter(value="is_internal", nulls=Nulls.SKIP)
        public Builder isInternal(Optional<Boolean> isInternal) {
            this.isInternal = isInternal;
            return this;
        }

        public Builder isInternal(Boolean isInternal) {
            this.isInternal = Optional.ofNullable(isInternal);
            return this;
        }

        public UpdateTicketTypeRequestBody build() {
            return new UpdateTicketTypeRequestBody(this.name, this.description, this.category, this.icon, this.archived, this.isInternal, this.additionalProperties);
        }
    }
}

