/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.App;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AdminWithApp {
    private final String id;
    private final String name;
    private final String email;
    private final String jobTitle;
    private final boolean awayModeEnabled;
    private final boolean awayModeReassign;
    private final boolean hasInboxSeat;
    private final List<Integer> teamIds;
    private final Optional<Avatar> avatar;
    private final Optional<Boolean> emailVerified;
    private final Optional<App> app;
    private final Map<String, Object> additionalProperties;

    private AdminWithApp(String id, String name, String email, String jobTitle, boolean awayModeEnabled, boolean awayModeReassign, boolean hasInboxSeat, List<Integer> teamIds, Optional<Avatar> avatar, Optional<Boolean> emailVerified, Optional<App> app, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.jobTitle = jobTitle;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.hasInboxSeat = hasInboxSeat;
        this.teamIds = teamIds;
        this.avatar = avatar;
        this.emailVerified = emailVerified;
        this.app = app;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "admin";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="job_title")
    public String getJobTitle() {
        return this.jobTitle;
    }

    @JsonProperty(value="away_mode_enabled")
    public boolean getAwayModeEnabled() {
        return this.awayModeEnabled;
    }

    @JsonProperty(value="away_mode_reassign")
    public boolean getAwayModeReassign() {
        return this.awayModeReassign;
    }

    @JsonProperty(value="has_inbox_seat")
    public boolean getHasInboxSeat() {
        return this.hasInboxSeat;
    }

    @JsonProperty(value="team_ids")
    public List<Integer> getTeamIds() {
        return this.teamIds;
    }

    @JsonProperty(value="avatar")
    public Optional<Avatar> getAvatar() {
        return this.avatar;
    }

    @JsonProperty(value="email_verified")
    public Optional<Boolean> getEmailVerified() {
        return this.emailVerified;
    }

    @JsonProperty(value="app")
    public Optional<App> getApp() {
        return this.app;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AdminWithApp && this.equalTo((AdminWithApp)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdminWithApp other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.email.equals(other.email) && this.jobTitle.equals(other.jobTitle) && this.awayModeEnabled == other.awayModeEnabled && this.awayModeReassign == other.awayModeReassign && this.hasInboxSeat == other.hasInboxSeat && this.teamIds.equals(other.teamIds) && this.avatar.equals(other.avatar) && this.emailVerified.equals(other.emailVerified) && this.app.equals(other.app);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.email, this.jobTitle, this.awayModeEnabled, this.awayModeReassign, this.hasInboxSeat, this.teamIds, this.avatar, this.emailVerified, this.app);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Avatar {
        private final Optional<String> type;
        private final Optional<String> imageUrl;
        private final Map<String, Object> additionalProperties;

        private Avatar(Optional<String> type, Optional<String> imageUrl, Map<String, Object> additionalProperties) {
            this.type = type;
            this.imageUrl = imageUrl;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="image_url")
        public Optional<String> getImageUrl() {
            return this.imageUrl;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Avatar && this.equalTo((Avatar)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Avatar other) {
            return this.type.equals(other.type) && this.imageUrl.equals(other.imageUrl);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.imageUrl);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<String> imageUrl = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Avatar other) {
                this.type(other.getType());
                this.imageUrl(other.getImageUrl());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="image_url", nulls=Nulls.SKIP)
            public Builder imageUrl(Optional<String> imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = Optional.ofNullable(imageUrl);
                return this;
            }

            public Avatar build() {
                return new Avatar(this.type, this.imageUrl, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    EmailStage,
    JobTitleStage,
    AwayModeEnabledStage,
    AwayModeReassignStage,
    HasInboxSeatStage,
    _FinalStage {
        private String id;
        private String name;
        private String email;
        private String jobTitle;
        private boolean awayModeEnabled;
        private boolean awayModeReassign;
        private boolean hasInboxSeat;
        private Optional<App> app = Optional.empty();
        private Optional<Boolean> emailVerified = Optional.empty();
        private Optional<Avatar> avatar = Optional.empty();
        private List<Integer> teamIds = new ArrayList<Integer>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AdminWithApp other) {
            this.id(other.getId());
            this.name(other.getName());
            this.email(other.getEmail());
            this.jobTitle(other.getJobTitle());
            this.awayModeEnabled(other.getAwayModeEnabled());
            this.awayModeReassign(other.getAwayModeReassign());
            this.hasInboxSeat(other.getHasInboxSeat());
            this.teamIds(other.getTeamIds());
            this.avatar(other.getAvatar());
            this.emailVerified(other.getEmailVerified());
            this.app(other.getApp());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public EmailStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public JobTitleStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="job_title")
        public AwayModeEnabledStage jobTitle(@NotNull String jobTitle) {
            this.jobTitle = Objects.requireNonNull(jobTitle, "jobTitle must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="away_mode_enabled")
        public AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        @Override
        @JsonSetter(value="away_mode_reassign")
        public HasInboxSeatStage awayModeReassign(boolean awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        @Override
        @JsonSetter(value="has_inbox_seat")
        public _FinalStage hasInboxSeat(boolean hasInboxSeat) {
            this.hasInboxSeat = hasInboxSeat;
            return this;
        }

        @Override
        public _FinalStage app(App app) {
            this.app = Optional.ofNullable(app);
            return this;
        }

        @Override
        @JsonSetter(value="app", nulls=Nulls.SKIP)
        public _FinalStage app(Optional<App> app) {
            this.app = app;
            return this;
        }

        @Override
        public _FinalStage emailVerified(Boolean emailVerified) {
            this.emailVerified = Optional.ofNullable(emailVerified);
            return this;
        }

        @Override
        @JsonSetter(value="email_verified", nulls=Nulls.SKIP)
        public _FinalStage emailVerified(Optional<Boolean> emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        @Override
        public _FinalStage avatar(Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @Override
        @JsonSetter(value="avatar", nulls=Nulls.SKIP)
        public _FinalStage avatar(Optional<Avatar> avatar) {
            this.avatar = avatar;
            return this;
        }

        @Override
        public _FinalStage addAllTeamIds(List<Integer> teamIds) {
            this.teamIds.addAll(teamIds);
            return this;
        }

        @Override
        public _FinalStage addTeamIds(Integer teamIds) {
            this.teamIds.add(teamIds);
            return this;
        }

        @Override
        @JsonSetter(value="team_ids", nulls=Nulls.SKIP)
        public _FinalStage teamIds(List<Integer> teamIds) {
            this.teamIds.clear();
            this.teamIds.addAll(teamIds);
            return this;
        }

        @Override
        public AdminWithApp build() {
            return new AdminWithApp(this.id, this.name, this.email, this.jobTitle, this.awayModeEnabled, this.awayModeReassign, this.hasInboxSeat, this.teamIds, this.avatar, this.emailVerified, this.app, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AdminWithApp build();

        public _FinalStage teamIds(List<Integer> var1);

        public _FinalStage addTeamIds(Integer var1);

        public _FinalStage addAllTeamIds(List<Integer> var1);

        public _FinalStage avatar(Optional<Avatar> var1);

        public _FinalStage avatar(Avatar var1);

        public _FinalStage emailVerified(Optional<Boolean> var1);

        public _FinalStage emailVerified(Boolean var1);

        public _FinalStage app(Optional<App> var1);

        public _FinalStage app(App var1);
    }

    public static interface HasInboxSeatStage {
        public _FinalStage hasInboxSeat(boolean var1);
    }

    public static interface AwayModeReassignStage {
        public HasInboxSeatStage awayModeReassign(boolean var1);
    }

    public static interface AwayModeEnabledStage {
        public AwayModeReassignStage awayModeEnabled(boolean var1);
    }

    public static interface JobTitleStage {
        public AwayModeEnabledStage jobTitle(@NotNull String var1);
    }

    public static interface EmailStage {
        public JobTitleStage email(@NotNull String var1);
    }

    public static interface NameStage {
        public EmailStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(AdminWithApp var1);
    }
}

