/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContactCompany;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactCompanies {
    private final Optional<String> type;
    private final Optional<List<ContactCompany>> data;
    private final String url;
    private final int totalCount;
    private final boolean hasMore;
    private final Map<String, Object> additionalProperties;

    private ContactCompanies(Optional<String> type, Optional<List<ContactCompany>> data, String url, int totalCount, boolean hasMore, Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.url = url;
        this.totalCount = totalCount;
        this.hasMore = hasMore;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="data")
    public Optional<List<ContactCompany>> getData() {
        return this.data;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="has_more")
    public boolean getHasMore() {
        return this.hasMore;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactCompanies && this.equalTo((ContactCompanies)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactCompanies other) {
        return this.type.equals(other.type) && this.data.equals(other.data) && this.url.equals(other.url) && this.totalCount == other.totalCount && this.hasMore == other.hasMore;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data, this.url, this.totalCount, this.hasMore);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UrlStage,
    TotalCountStage,
    HasMoreStage,
    _FinalStage {
        private String url;
        private int totalCount;
        private boolean hasMore;
        private Optional<List<ContactCompany>> data = Optional.empty();
        private Optional<String> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContactCompanies other) {
            this.type(other.getType());
            this.data(other.getData());
            this.url(other.getUrl());
            this.totalCount(other.getTotalCount());
            this.hasMore(other.getHasMore());
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public TotalCountStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public HasMoreStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        @JsonSetter(value="has_more")
        public _FinalStage hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        @Override
        public _FinalStage data(List<ContactCompany> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @Override
        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public _FinalStage data(Optional<List<ContactCompany>> data) {
            this.data = data;
            return this;
        }

        @Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @Override
        public ContactCompanies build() {
            return new ContactCompanies(this.type, this.data, this.url, this.totalCount, this.hasMore, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContactCompanies build();

        public _FinalStage type(Optional<String> var1);

        public _FinalStage type(String var1);

        public _FinalStage data(Optional<List<ContactCompany>> var1);

        public _FinalStage data(List<ContactCompany> var1);
    }

    public static interface HasMoreStage {
        public _FinalStage hasMore(boolean var1);
    }

    public static interface TotalCountStage {
        public HasMoreStage totalCount(int var1);
    }

    public static interface UrlStage {
        public TotalCountStage url(@NotNull String var1);

        public Builder from(ContactCompanies var1);
    }
}

