/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactDeleted {
    private final String id;
    private final Optional<String> externalId;
    private final boolean deleted;
    private final Map<String, Object> additionalProperties;

    private ContactDeleted(String id, Optional<String> externalId, boolean deleted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.externalId = externalId;
        this.deleted = deleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "contact";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="deleted")
    public boolean getDeleted() {
        return this.deleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactDeleted && this.equalTo((ContactDeleted)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactDeleted other) {
        return this.id.equals(other.id) && this.externalId.equals(other.externalId) && this.deleted == other.deleted;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.externalId, this.deleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    DeletedStage,
    _FinalStage {
        private String id;
        private boolean deleted;
        private Optional<String> externalId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContactDeleted other) {
            this.id(other.getId());
            this.externalId(other.getExternalId());
            this.deleted(other.getDeleted());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public DeletedStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="deleted")
        public _FinalStage deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public ContactDeleted build() {
            return new ContactDeleted(this.id, this.externalId, this.deleted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContactDeleted build();

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);
    }

    public static interface DeletedStage {
        public _FinalStage deleted(boolean var1);
    }

    public static interface IdStage {
        public DeletedStage id(@NotNull String var1);

        public Builder from(ContactDeleted var1);
    }
}

