/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Context {
    private final Optional<Integer> conversationId;
    private final Optional<Location> location;
    private final Optional<String> locale;
    private final Optional<String> messengerActionColour;
    private final Optional<String> messengerBackgroundColour;
    private final Optional<String> referrer;
    private final Map<String, Object> additionalProperties;

    private Context(Optional<Integer> conversationId, Optional<Location> location, Optional<String> locale, Optional<String> messengerActionColour, Optional<String> messengerBackgroundColour, Optional<String> referrer, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.location = location;
        this.locale = locale;
        this.messengerActionColour = messengerActionColour;
        this.messengerBackgroundColour = messengerBackgroundColour;
        this.referrer = referrer;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public Optional<Integer> getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="location")
    public Optional<Location> getLocation() {
        return this.location;
    }

    @JsonProperty(value="locale")
    public Optional<String> getLocale() {
        return this.locale;
    }

    @JsonProperty(value="messenger_action_colour")
    public Optional<String> getMessengerActionColour() {
        return this.messengerActionColour;
    }

    @JsonProperty(value="messenger_background_colour")
    public Optional<String> getMessengerBackgroundColour() {
        return this.messengerBackgroundColour;
    }

    @JsonProperty(value="referrer")
    public Optional<String> getReferrer() {
        return this.referrer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Context && this.equalTo((Context)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Context other) {
        return this.conversationId.equals(other.conversationId) && this.location.equals(other.location) && this.locale.equals(other.locale) && this.messengerActionColour.equals(other.messengerActionColour) && this.messengerBackgroundColour.equals(other.messengerBackgroundColour) && this.referrer.equals(other.referrer);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.location, this.locale, this.messengerActionColour, this.messengerBackgroundColour, this.referrer);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Location {
        public static final Location OPERATOR = new Location(Value.OPERATOR, "operator");
        public static final Location MESSAGE = new Location(Value.MESSAGE, "message");
        public static final Location HOME = new Location(Value.HOME, "home");
        public static final Location CONVERSATION = new Location(Value.CONVERSATION, "conversation");
        private final Value value;
        private final String string;

        Location(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Location && this.string.equals(((Location)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case OPERATOR: {
                    return visitor.visitOperator();
                }
                case MESSAGE: {
                    return visitor.visitMessage();
                }
                case HOME: {
                    return visitor.visitHome();
                }
                case CONVERSATION: {
                    return visitor.visitConversation();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Location valueOf(String value) {
            switch (value) {
                case "operator": {
                    return OPERATOR;
                }
                case "message": {
                    return MESSAGE;
                }
                case "home": {
                    return HOME;
                }
                case "conversation": {
                    return CONVERSATION;
                }
            }
            return new Location(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitConversation();

            public T visitHome();

            public T visitMessage();

            public T visitOperator();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CONVERSATION,
            HOME,
            MESSAGE,
            OPERATOR,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> conversationId = Optional.empty();
        private Optional<Location> location = Optional.empty();
        private Optional<String> locale = Optional.empty();
        private Optional<String> messengerActionColour = Optional.empty();
        private Optional<String> messengerBackgroundColour = Optional.empty();
        private Optional<String> referrer = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Context other) {
            this.conversationId(other.getConversationId());
            this.location(other.getLocation());
            this.locale(other.getLocale());
            this.messengerActionColour(other.getMessengerActionColour());
            this.messengerBackgroundColour(other.getMessengerBackgroundColour());
            this.referrer(other.getReferrer());
            return this;
        }

        @JsonSetter(value="conversation_id", nulls=Nulls.SKIP)
        public Builder conversationId(Optional<Integer> conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder conversationId(Integer conversationId) {
            this.conversationId = Optional.ofNullable(conversationId);
            return this;
        }

        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public Builder location(Optional<Location> location) {
            this.location = location;
            return this;
        }

        public Builder location(Location location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @JsonSetter(value="locale", nulls=Nulls.SKIP)
        public Builder locale(Optional<String> locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        @JsonSetter(value="messenger_action_colour", nulls=Nulls.SKIP)
        public Builder messengerActionColour(Optional<String> messengerActionColour) {
            this.messengerActionColour = messengerActionColour;
            return this;
        }

        public Builder messengerActionColour(String messengerActionColour) {
            this.messengerActionColour = Optional.ofNullable(messengerActionColour);
            return this;
        }

        @JsonSetter(value="messenger_background_colour", nulls=Nulls.SKIP)
        public Builder messengerBackgroundColour(Optional<String> messengerBackgroundColour) {
            this.messengerBackgroundColour = messengerBackgroundColour;
            return this;
        }

        public Builder messengerBackgroundColour(String messengerBackgroundColour) {
            this.messengerBackgroundColour = Optional.ofNullable(messengerBackgroundColour);
            return this;
        }

        @JsonSetter(value="referrer", nulls=Nulls.SKIP)
        public Builder referrer(Optional<String> referrer) {
            this.referrer = referrer;
            return this;
        }

        public Builder referrer(String referrer) {
            this.referrer = Optional.ofNullable(referrer);
            return this;
        }

        public Context build() {
            return new Context(this.conversationId, this.location, this.locale, this.messengerActionColour, this.messengerBackgroundColour, this.referrer, this.additionalProperties);
        }
    }
}

