/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PagesLink {
    private final int page;
    private final Optional<String> next;
    private final int perPage;
    private final int totalPages;
    private final Map<String, Object> additionalProperties;

    private PagesLink(int page, Optional<String> next, int perPage, int totalPages, Map<String, Object> additionalProperties) {
        this.page = page;
        this.next = next;
        this.perPage = perPage;
        this.totalPages = totalPages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "pages";
    }

    @JsonProperty(value="page")
    public int getPage() {
        return this.page;
    }

    @JsonProperty(value="next")
    public Optional<String> getNext() {
        return this.next;
    }

    @JsonProperty(value="per_page")
    public int getPerPage() {
        return this.perPage;
    }

    @JsonProperty(value="total_pages")
    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PagesLink && this.equalTo((PagesLink)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PagesLink other) {
        return this.page == other.page && this.next.equals(other.next) && this.perPage == other.perPage && this.totalPages == other.totalPages;
    }

    public int hashCode() {
        return Objects.hash(this.page, this.next, this.perPage, this.totalPages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PageStage,
    PerPageStage,
    TotalPagesStage,
    _FinalStage {
        private int page;
        private int perPage;
        private int totalPages;
        private Optional<String> next = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PagesLink other) {
            this.page(other.getPage());
            this.next(other.getNext());
            this.perPage(other.getPerPage());
            this.totalPages(other.getTotalPages());
            return this;
        }

        @Override
        @JsonSetter(value="page")
        public PerPageStage page(int page) {
            this.page = page;
            return this;
        }

        @Override
        @JsonSetter(value="per_page")
        public TotalPagesStage perPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        @Override
        @JsonSetter(value="total_pages")
        public _FinalStage totalPages(int totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        @Override
        public _FinalStage next(String next) {
            this.next = Optional.ofNullable(next);
            return this;
        }

        @Override
        @JsonSetter(value="next", nulls=Nulls.SKIP)
        public _FinalStage next(Optional<String> next) {
            this.next = next;
            return this;
        }

        @Override
        public PagesLink build() {
            return new PagesLink(this.page, this.next, this.perPage, this.totalPages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PagesLink build();

        public _FinalStage next(Optional<String> var1);

        public _FinalStage next(String var1);
    }

    public static interface TotalPagesStage {
        public _FinalStage totalPages(int var1);
    }

    public static interface PerPageStage {
        public TotalPagesStage perPage(int var1);
    }

    public static interface PageStage {
        public PerPageStage page(int var1);

        public Builder from(PagesLink var1);
    }
}

