/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketTypeAttribute {
    private final String id;
    private final String workspaceId;
    private final String name;
    private final String description;
    private final DataType dataType;
    private final Map<String, Object> inputOptions;
    private final int order;
    private final boolean requiredToCreate;
    private final boolean requiredToCreateForContacts;
    private final boolean visibleOnCreate;
    private final boolean visibleToContacts;
    private final boolean default_;
    private final int ticketTypeId;
    private final boolean archived;
    private final int createdAt;
    private final Optional<Integer> updatedAt;
    private final Map<String, Object> additionalProperties;

    private TicketTypeAttribute(String id, String workspaceId, String name, String description, DataType dataType, Map<String, Object> inputOptions, int order, boolean requiredToCreate, boolean requiredToCreateForContacts, boolean visibleOnCreate, boolean visibleToContacts, boolean default_, int ticketTypeId, boolean archived, int createdAt, Optional<Integer> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.inputOptions = inputOptions;
        this.order = order;
        this.requiredToCreate = requiredToCreate;
        this.requiredToCreateForContacts = requiredToCreateForContacts;
        this.visibleOnCreate = visibleOnCreate;
        this.visibleToContacts = visibleToContacts;
        this.default_ = default_;
        this.ticketTypeId = ticketTypeId;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "ticket_type_attribute";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="data_type")
    public DataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="input_options")
    public Map<String, Object> getInputOptions() {
        return this.inputOptions;
    }

    @JsonProperty(value="order")
    public int getOrder() {
        return this.order;
    }

    @JsonProperty(value="required_to_create")
    public boolean getRequiredToCreate() {
        return this.requiredToCreate;
    }

    @JsonProperty(value="required_to_create_for_contacts")
    public boolean getRequiredToCreateForContacts() {
        return this.requiredToCreateForContacts;
    }

    @JsonProperty(value="visible_on_create")
    public boolean getVisibleOnCreate() {
        return this.visibleOnCreate;
    }

    @JsonProperty(value="visible_to_contacts")
    public boolean getVisibleToContacts() {
        return this.visibleToContacts;
    }

    @JsonProperty(value="default")
    public boolean getDefault() {
        return this.default_;
    }

    @JsonProperty(value="ticket_type_id")
    public int getTicketTypeId() {
        return this.ticketTypeId;
    }

    @JsonProperty(value="archived")
    public boolean getArchived() {
        return this.archived;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketTypeAttribute && this.equalTo((TicketTypeAttribute)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketTypeAttribute other) {
        return this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.name.equals(other.name) && this.description.equals(other.description) && this.dataType.equals(other.dataType) && this.inputOptions.equals(other.inputOptions) && this.order == other.order && this.requiredToCreate == other.requiredToCreate && this.requiredToCreateForContacts == other.requiredToCreateForContacts && this.visibleOnCreate == other.visibleOnCreate && this.visibleToContacts == other.visibleToContacts && this.default_ == other.default_ && this.ticketTypeId == other.ticketTypeId && this.archived == other.archived && this.createdAt == other.createdAt && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.workspaceId, this.name, this.description, this.dataType, this.inputOptions, this.order, this.requiredToCreate, this.requiredToCreateForContacts, this.visibleOnCreate, this.visibleToContacts, this.default_, this.ticketTypeId, this.archived, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");
        public static final DataType DECIMAL = new DataType(Value.DECIMAL, "decimal");
        public static final DataType LIST = new DataType(Value.LIST, "list");
        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");
        public static final DataType DATETIME = new DataType(Value.DATETIME, "datetime");
        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");
        public static final DataType FILES = new DataType(Value.FILES, "files");
        private final Value value;
        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DataType && this.string.equals(((DataType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case STRING: {
                    return visitor.visitString();
                }
                case DECIMAL: {
                    return visitor.visitDecimal();
                }
                case LIST: {
                    return visitor.visitList();
                }
                case INTEGER: {
                    return visitor.visitInteger();
                }
                case DATETIME: {
                    return visitor.visitDatetime();
                }
                case BOOLEAN: {
                    return visitor.visitBoolean();
                }
                case FILES: {
                    return visitor.visitFiles();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string": {
                    return STRING;
                }
                case "decimal": {
                    return DECIMAL;
                }
                case "list": {
                    return LIST;
                }
                case "integer": {
                    return INTEGER;
                }
                case "datetime": {
                    return DATETIME;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "files": {
                    return FILES;
                }
            }
            return new DataType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitString();

            public T visitList();

            public T visitInteger();

            public T visitDecimal();

            public T visitBoolean();

            public T visitDatetime();

            public T visitFiles();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            STRING,
            LIST,
            INTEGER,
            DECIMAL,
            BOOLEAN,
            DATETIME,
            FILES,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    WorkspaceIdStage,
    NameStage,
    DescriptionStage,
    DataTypeStage,
    OrderStage,
    RequiredToCreateStage,
    RequiredToCreateForContactsStage,
    VisibleOnCreateStage,
    VisibleToContactsStage,
    DefaultStage,
    TicketTypeIdStage,
    ArchivedStage,
    CreatedAtStage,
    _FinalStage {
        private String id;
        private String workspaceId;
        private String name;
        private String description;
        private DataType dataType;
        private int order;
        private boolean requiredToCreate;
        private boolean requiredToCreateForContacts;
        private boolean visibleOnCreate;
        private boolean visibleToContacts;
        private boolean default_;
        private int ticketTypeId;
        private boolean archived;
        private int createdAt;
        private Optional<Integer> updatedAt = Optional.empty();
        private Map<String, Object> inputOptions = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TicketTypeAttribute other) {
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.dataType(other.getDataType());
            this.inputOptions(other.getInputOptions());
            this.order(other.getOrder());
            this.requiredToCreate(other.getRequiredToCreate());
            this.requiredToCreateForContacts(other.getRequiredToCreateForContacts());
            this.visibleOnCreate(other.getVisibleOnCreate());
            this.visibleToContacts(other.getVisibleToContacts());
            this.default_(other.getDefault());
            this.ticketTypeId(other.getTicketTypeId());
            this.archived(other.getArchived());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public NameStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public DataTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="data_type")
        public OrderStage dataType(@NotNull DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order")
        public RequiredToCreateStage order(int order) {
            this.order = order;
            return this;
        }

        @Override
        @JsonSetter(value="required_to_create")
        public RequiredToCreateForContactsStage requiredToCreate(boolean requiredToCreate) {
            this.requiredToCreate = requiredToCreate;
            return this;
        }

        @Override
        @JsonSetter(value="required_to_create_for_contacts")
        public VisibleOnCreateStage requiredToCreateForContacts(boolean requiredToCreateForContacts) {
            this.requiredToCreateForContacts = requiredToCreateForContacts;
            return this;
        }

        @Override
        @JsonSetter(value="visible_on_create")
        public VisibleToContactsStage visibleOnCreate(boolean visibleOnCreate) {
            this.visibleOnCreate = visibleOnCreate;
            return this;
        }

        @Override
        @JsonSetter(value="visible_to_contacts")
        public DefaultStage visibleToContacts(boolean visibleToContacts) {
            this.visibleToContacts = visibleToContacts;
            return this;
        }

        @Override
        @JsonSetter(value="default")
        public TicketTypeIdStage default_(boolean default_) {
            this.default_ = default_;
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type_id")
        public ArchivedStage ticketTypeId(int ticketTypeId) {
            this.ticketTypeId = ticketTypeId;
            return this;
        }

        @Override
        @JsonSetter(value="archived")
        public CreatedAtStage archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage inputOptions(String key, Object value) {
            this.inputOptions.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllInputOptions(Map<String, Object> inputOptions) {
            this.inputOptions.putAll(inputOptions);
            return this;
        }

        @Override
        @JsonSetter(value="input_options", nulls=Nulls.SKIP)
        public _FinalStage inputOptions(Map<String, Object> inputOptions) {
            this.inputOptions.clear();
            this.inputOptions.putAll(inputOptions);
            return this;
        }

        @Override
        public TicketTypeAttribute build() {
            return new TicketTypeAttribute(this.id, this.workspaceId, this.name, this.description, this.dataType, this.inputOptions, this.order, this.requiredToCreate, this.requiredToCreateForContacts, this.visibleOnCreate, this.visibleToContacts, this.default_, this.ticketTypeId, this.archived, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TicketTypeAttribute build();

        public _FinalStage inputOptions(Map<String, Object> var1);

        public _FinalStage putAllInputOptions(Map<String, Object> var1);

        public _FinalStage inputOptions(String var1, Object var2);

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);
    }

    public static interface CreatedAtStage {
        public _FinalStage createdAt(int var1);
    }

    public static interface ArchivedStage {
        public CreatedAtStage archived(boolean var1);
    }

    public static interface TicketTypeIdStage {
        public ArchivedStage ticketTypeId(int var1);
    }

    public static interface DefaultStage {
        public TicketTypeIdStage default_(boolean var1);
    }

    public static interface VisibleToContactsStage {
        public DefaultStage visibleToContacts(boolean var1);
    }

    public static interface VisibleOnCreateStage {
        public VisibleToContactsStage visibleOnCreate(boolean var1);
    }

    public static interface RequiredToCreateForContactsStage {
        public VisibleOnCreateStage requiredToCreateForContacts(boolean var1);
    }

    public static interface RequiredToCreateStage {
        public RequiredToCreateForContactsStage requiredToCreate(boolean var1);
    }

    public static interface OrderStage {
        public RequiredToCreateStage order(int var1);
    }

    public static interface DataTypeStage {
        public OrderStage dataType(@NotNull DataType var1);
    }

    public static interface DescriptionStage {
        public DataTypeStage description(@NotNull String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(@NotNull String var1);
    }

    public static interface WorkspaceIdStage {
        public NameStage workspaceId(@NotNull String var1);
    }

    public static interface IdStage {
        public WorkspaceIdStage id(@NotNull String var1);

        public Builder from(TicketTypeAttribute var1);
    }
}

