/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.articles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.articles.AsyncRawArticlesClient;
import com.intercom.api.resources.articles.requests.DeleteArticleRequest;
import com.intercom.api.resources.articles.requests.FindArticleRequest;
import com.intercom.api.resources.articles.requests.ListArticlesRequest;
import com.intercom.api.resources.articles.requests.SearchArticlesRequest;
import com.intercom.api.resources.articles.requests.UpdateArticleRequest;
import com.intercom.api.resources.articles.types.Article;
import com.intercom.api.resources.articles.types.ArticleListItem;
import com.intercom.api.resources.articles.types.ArticleSearchResponse;
import com.intercom.api.types.CreateArticleRequest;
import com.intercom.api.types.DeletedArticleObject;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncArticlesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawArticlesClient rawClient;

    public AsyncArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawArticlesClient(clientOptions);
    }

    public AsyncRawArticlesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<ArticleListItem>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<ArticleListItem>> list(ListArticlesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<ArticleListItem>> list(ListArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<Article> create() {
        return this.rawClient.create().thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> create(Optional<CreateArticleRequest> request) {
        return this.rawClient.create(request).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> create(Optional<CreateArticleRequest> request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> find(FindArticleRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> find(FindArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> update(UpdateArticleRequest request) {
        return this.rawClient.update(request).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<Article> update(UpdateArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (Article)response.body());
    }

    public CompletableFuture<DeletedArticleObject> delete(DeleteArticleRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeletedArticleObject)response.body());
    }

    public CompletableFuture<DeletedArticleObject> delete(DeleteArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeletedArticleObject)response.body());
    }

    public CompletableFuture<ArticleSearchResponse> search() {
        return this.rawClient.search().thenApply(response -> (ArticleSearchResponse)response.body());
    }

    public CompletableFuture<ArticleSearchResponse> search(SearchArticlesRequest request) {
        return this.rawClient.search(request).thenApply(response -> (ArticleSearchResponse)response.body());
    }

    public CompletableFuture<ArticleSearchResponse> search(SearchArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (ArticleSearchResponse)response.body());
    }
}

