/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.calls;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.calls.RawCallsClient;
import com.intercom.api.resources.calls.requests.ListCallsRequest;
import com.intercom.api.resources.calls.requests.ListCallsWithTranscriptsRequest;
import com.intercom.api.resources.calls.requests.ShowCallRecordingRequest;
import com.intercom.api.resources.calls.requests.ShowCallRequest;
import com.intercom.api.resources.calls.requests.ShowCallTranscriptRequest;
import com.intercom.api.resources.calls.types.Call;
import com.intercom.api.resources.calls.types.ListCallsWithTranscriptsResponse;
import com.intercom.api.types.CallList;

public class CallsClient {
    protected final ClientOptions clientOptions;
    private final RawCallsClient rawClient;

    public CallsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCallsClient(clientOptions);
    }

    public RawCallsClient withRawResponse() {
        return this.rawClient;
    }

    public CallList listCalls() {
        return this.rawClient.listCalls().body();
    }

    public CallList listCalls(ListCallsRequest request) {
        return this.rawClient.listCalls(request).body();
    }

    public CallList listCalls(ListCallsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCalls(request, requestOptions).body();
    }

    public Call showCall(ShowCallRequest request) {
        return this.rawClient.showCall(request).body();
    }

    public Call showCall(ShowCallRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCall(request, requestOptions).body();
    }

    public void showCallRecording(ShowCallRecordingRequest request) {
        this.rawClient.showCallRecording(request).body();
    }

    public void showCallRecording(ShowCallRecordingRequest request, RequestOptions requestOptions) {
        this.rawClient.showCallRecording(request, requestOptions).body();
    }

    public String showCallTranscript(ShowCallTranscriptRequest request) {
        return this.rawClient.showCallTranscript(request).body();
    }

    public String showCallTranscript(ShowCallTranscriptRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallTranscript(request, requestOptions).body();
    }

    public ListCallsWithTranscriptsResponse listCallsWithTranscripts(ListCallsWithTranscriptsRequest request) {
        return this.rawClient.listCallsWithTranscripts(request).body();
    }

    public ListCallsWithTranscriptsResponse listCallsWithTranscripts(ListCallsWithTranscriptsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCallsWithTranscripts(request, requestOptions).body();
    }
}

