/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataexport;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.dataexport.RawDataExportClient;
import com.intercom.api.resources.dataexport.requests.CancelDataExportRequest;
import com.intercom.api.resources.dataexport.requests.CreateDataExportRequest;
import com.intercom.api.resources.dataexport.requests.DownloadDataExportRequest;
import com.intercom.api.resources.dataexport.requests.DownloadReportingDataExportRequest;
import com.intercom.api.resources.dataexport.requests.ExportReportingDataRequest;
import com.intercom.api.resources.dataexport.requests.FindDataExportRequest;
import com.intercom.api.resources.dataexport.types.DataExport;
import com.intercom.api.resources.dataexport.types.DataExportExportReportingDataResponse;

public class DataExportClient {
    protected final ClientOptions clientOptions;
    private final RawDataExportClient rawClient;

    public DataExportClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDataExportClient(clientOptions);
    }

    public RawDataExportClient withRawResponse() {
        return this.rawClient;
    }

    public DataExportExportReportingDataResponse exportReportingData(ExportReportingDataRequest request) {
        return this.rawClient.exportReportingData(request).body();
    }

    public DataExportExportReportingDataResponse exportReportingData(ExportReportingDataRequest request, RequestOptions requestOptions) {
        return this.rawClient.exportReportingData(request, requestOptions).body();
    }

    public void downloadReportingDataExport(DownloadReportingDataExportRequest request) {
        this.rawClient.downloadReportingDataExport(request).body();
    }

    public void downloadReportingDataExport(DownloadReportingDataExportRequest request, RequestOptions requestOptions) {
        this.rawClient.downloadReportingDataExport(request, requestOptions).body();
    }

    public DataExport create(CreateDataExportRequest request) {
        return this.rawClient.create(request).body();
    }

    public DataExport create(CreateDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public DataExport find(FindDataExportRequest request) {
        return this.rawClient.find(request).body();
    }

    public DataExport find(FindDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public DataExport cancel(CancelDataExportRequest request) {
        return this.rawClient.cancel(request).body();
    }

    public DataExport cancel(CancelDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).body();
    }

    public void download(DownloadDataExportRequest request) {
        this.rawClient.download(request).body();
    }

    public void download(DownloadDataExportRequest request, RequestOptions requestOptions) {
        this.rawClient.download(request, requestOptions).body();
    }
}

