/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class HelpCenter {
    private final String id;
    private final String workspaceId;
    private final int createdAt;
    private final int updatedAt;
    private final String identifier;
    private final Optional<Boolean> websiteTurnedOn;
    private final Optional<String> displayName;
    private final Optional<String> url;
    private final Optional<String> customDomain;
    private final Map<String, Object> additionalProperties;

    private HelpCenter(String id, String workspaceId, int createdAt, int updatedAt, String identifier, Optional<Boolean> websiteTurnedOn, Optional<String> displayName, Optional<String> url, Optional<String> customDomain, Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.identifier = identifier;
        this.websiteTurnedOn = websiteTurnedOn;
        this.displayName = displayName;
        this.url = url;
        this.customDomain = customDomain;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="website_turned_on")
    public Optional<Boolean> getWebsiteTurnedOn() {
        return this.websiteTurnedOn;
    }

    @JsonProperty(value="display_name")
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="custom_domain")
    public Optional<String> getCustomDomain() {
        return this.customDomain;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof HelpCenter && this.equalTo((HelpCenter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HelpCenter other) {
        return this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.identifier.equals(other.identifier) && this.websiteTurnedOn.equals(other.websiteTurnedOn) && this.displayName.equals(other.displayName) && this.url.equals(other.url) && this.customDomain.equals(other.customDomain);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.workspaceId, this.createdAt, this.updatedAt, this.identifier, this.websiteTurnedOn, this.displayName, this.url, this.customDomain);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    WorkspaceIdStage,
    CreatedAtStage,
    UpdatedAtStage,
    IdentifierStage,
    _FinalStage {
        private String id;
        private String workspaceId;
        private int createdAt;
        private int updatedAt;
        private String identifier;
        private Optional<String> customDomain = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> displayName = Optional.empty();
        private Optional<Boolean> websiteTurnedOn = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(HelpCenter other) {
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.identifier(other.getIdentifier());
            this.websiteTurnedOn(other.getWebsiteTurnedOn());
            this.displayName(other.getDisplayName());
            this.url(other.getUrl());
            this.customDomain(other.getCustomDomain());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public CreatedAtStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public IdentifierStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="identifier")
        public _FinalStage identifier(@NotNull String identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier must not be null");
            return this;
        }

        @Override
        public _FinalStage customDomain(String customDomain) {
            this.customDomain = Optional.ofNullable(customDomain);
            return this;
        }

        @Override
        @JsonSetter(value="custom_domain", nulls=Nulls.SKIP)
        public _FinalStage customDomain(Optional<String> customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage displayName(String displayName) {
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        @Override
        @JsonSetter(value="display_name", nulls=Nulls.SKIP)
        public _FinalStage displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public _FinalStage websiteTurnedOn(Boolean websiteTurnedOn) {
            this.websiteTurnedOn = Optional.ofNullable(websiteTurnedOn);
            return this;
        }

        @Override
        @JsonSetter(value="website_turned_on", nulls=Nulls.SKIP)
        public _FinalStage websiteTurnedOn(Optional<Boolean> websiteTurnedOn) {
            this.websiteTurnedOn = websiteTurnedOn;
            return this;
        }

        @Override
        public HelpCenter build() {
            return new HelpCenter(this.id, this.workspaceId, this.createdAt, this.updatedAt, this.identifier, this.websiteTurnedOn, this.displayName, this.url, this.customDomain, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public HelpCenter build();

        public _FinalStage websiteTurnedOn(Optional<Boolean> var1);

        public _FinalStage websiteTurnedOn(Boolean var1);

        public _FinalStage displayName(Optional<String> var1);

        public _FinalStage displayName(String var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage customDomain(Optional<String> var1);

        public _FinalStage customDomain(String var1);
    }

    public static interface IdentifierStage {
        public _FinalStage identifier(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public IdentifierStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface WorkspaceIdStage {
        public CreatedAtStage workspaceId(@NotNull String var1);
    }

    public static interface IdStage {
        public WorkspaceIdStage id(@NotNull String var1);

        public Builder from(HelpCenter var1);
    }
}

