/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.jobs.types.Jobs;
import com.intercom.api.resources.tickets.AsyncRawTicketsClient;
import com.intercom.api.resources.tickets.requests.CreateTicketRequest;
import com.intercom.api.resources.tickets.requests.DeleteTicketRequest;
import com.intercom.api.resources.tickets.requests.EnqueueCreateTicketRequest;
import com.intercom.api.resources.tickets.requests.FindTicketRequest;
import com.intercom.api.resources.tickets.requests.ReplyToTicketRequest;
import com.intercom.api.resources.tickets.requests.UpdateTicketRequest;
import com.intercom.api.resources.tickets.types.DeleteTicketResponse;
import com.intercom.api.resources.tickets.types.Ticket;
import com.intercom.api.types.SearchRequest;
import com.intercom.api.types.TicketReply;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTicketsClient rawClient;

    public AsyncTicketsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketsClient(clientOptions);
    }

    public AsyncRawTicketsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TicketReply> reply(ReplyToTicketRequest request) {
        return this.rawClient.reply(request).thenApply(response -> (TicketReply)response.body());
    }

    public CompletableFuture<TicketReply> reply(ReplyToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.reply(request, requestOptions).thenApply(response -> (TicketReply)response.body());
    }

    public CompletableFuture<Optional<Ticket>> create(CreateTicketRequest request) {
        return this.rawClient.create(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> create(CreateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Jobs> enqueueCreateTicket(EnqueueCreateTicketRequest request) {
        return this.rawClient.enqueueCreateTicket(request).thenApply(response -> (Jobs)response.body());
    }

    public CompletableFuture<Jobs> enqueueCreateTicket(EnqueueCreateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.enqueueCreateTicket(request, requestOptions).thenApply(response -> (Jobs)response.body());
    }

    public CompletableFuture<Optional<Ticket>> get(FindTicketRequest request) {
        return this.rawClient.get(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> get(FindTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> update(UpdateTicketRequest request) {
        return this.rawClient.update(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> update(UpdateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<DeleteTicketResponse> deleteTicket(DeleteTicketRequest request) {
        return this.rawClient.deleteTicket(request).thenApply(response -> (DeleteTicketResponse)response.body());
    }

    public CompletableFuture<DeleteTicketResponse> deleteTicket(DeleteTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteTicket(request, requestOptions).thenApply(response -> (DeleteTicketResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Optional<Ticket>>> search(SearchRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Optional<Ticket>>> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }
}

