/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.admins.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SetAwayAdminRequest {
    private final int id;
    private final boolean awayModeEnabled;
    private final boolean awayModeReassign;
    private final Optional<Integer> awayStatusReasonId;
    private final Map<String, Object> additionalProperties;

    private SetAwayAdminRequest(int id, boolean awayModeEnabled, boolean awayModeReassign, Optional<Integer> awayStatusReasonId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.awayStatusReasonId = awayStatusReasonId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="away_mode_enabled")
    public boolean getAwayModeEnabled() {
        return this.awayModeEnabled;
    }

    @JsonProperty(value="away_mode_reassign")
    public boolean getAwayModeReassign() {
        return this.awayModeReassign;
    }

    @JsonProperty(value="away_status_reason_id")
    public Optional<Integer> getAwayStatusReasonId() {
        return this.awayStatusReasonId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SetAwayAdminRequest && this.equalTo((SetAwayAdminRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SetAwayAdminRequest other) {
        return this.id == other.id && this.awayModeEnabled == other.awayModeEnabled && this.awayModeReassign == other.awayModeReassign && this.awayStatusReasonId.equals(other.awayStatusReasonId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.awayModeEnabled, this.awayModeReassign, this.awayStatusReasonId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    AwayModeEnabledStage,
    AwayModeReassignStage,
    _FinalStage {
        private int id;
        private boolean awayModeEnabled;
        private boolean awayModeReassign;
        private Optional<Integer> awayStatusReasonId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SetAwayAdminRequest other) {
            this.id(other.getId());
            this.awayModeEnabled(other.getAwayModeEnabled());
            this.awayModeReassign(other.getAwayModeReassign());
            this.awayStatusReasonId(other.getAwayStatusReasonId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public AwayModeEnabledStage id(int id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="away_mode_enabled")
        public AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        @Override
        @JsonSetter(value="away_mode_reassign")
        public _FinalStage awayModeReassign(boolean awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        @Override
        public _FinalStage awayStatusReasonId(Integer awayStatusReasonId) {
            this.awayStatusReasonId = Optional.ofNullable(awayStatusReasonId);
            return this;
        }

        @Override
        @JsonSetter(value="away_status_reason_id", nulls=Nulls.SKIP)
        public _FinalStage awayStatusReasonId(Optional<Integer> awayStatusReasonId) {
            this.awayStatusReasonId = awayStatusReasonId;
            return this;
        }

        @Override
        public SetAwayAdminRequest build() {
            return new SetAwayAdminRequest(this.id, this.awayModeEnabled, this.awayModeReassign, this.awayStatusReasonId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SetAwayAdminRequest build();

        public _FinalStage awayStatusReasonId(Optional<Integer> var1);

        public _FinalStage awayStatusReasonId(Integer var1);
    }

    public static interface AwayModeReassignStage {
        public _FinalStage awayModeReassign(boolean var1);
    }

    public static interface AwayModeEnabledStage {
        public AwayModeReassignStage awayModeEnabled(boolean var1);
    }

    public static interface IdStage {
        public AwayModeEnabledStage id(int var1);

        public Builder from(SetAwayAdminRequest var1);
    }
}

