/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.aiagent.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ContentSourcesList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AiAgent {
    private final Optional<SourceType> sourceType;
    private final Optional<String> sourceTitle;
    private final Optional<LastAnswerType> lastAnswerType;
    private final Optional<ResolutionState> resolutionState;
    private final Optional<Integer> rating;
    private final Optional<String> ratingRemark;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<ContentSourcesList> contentSources;
    private final Map<String, Object> additionalProperties;

    private AiAgent(Optional<SourceType> sourceType, Optional<String> sourceTitle, Optional<LastAnswerType> lastAnswerType, Optional<ResolutionState> resolutionState, Optional<Integer> rating, Optional<String> ratingRemark, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<ContentSourcesList> contentSources, Map<String, Object> additionalProperties) {
        this.sourceType = sourceType;
        this.sourceTitle = sourceTitle;
        this.lastAnswerType = lastAnswerType;
        this.resolutionState = resolutionState;
        this.rating = rating;
        this.ratingRemark = ratingRemark;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.contentSources = contentSources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="source_type")
    public Optional<SourceType> getSourceType() {
        return this.sourceType;
    }

    @JsonProperty(value="source_title")
    public Optional<String> getSourceTitle() {
        return this.sourceTitle;
    }

    @JsonProperty(value="last_answer_type")
    public Optional<LastAnswerType> getLastAnswerType() {
        return this.lastAnswerType;
    }

    @JsonProperty(value="resolution_state")
    public Optional<ResolutionState> getResolutionState() {
        return this.resolutionState;
    }

    @JsonProperty(value="rating")
    public Optional<Integer> getRating() {
        return this.rating;
    }

    @JsonProperty(value="rating_remark")
    public Optional<String> getRatingRemark() {
        return this.ratingRemark;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="content_sources")
    public Optional<ContentSourcesList> getContentSources() {
        return this.contentSources;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AiAgent && this.equalTo((AiAgent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AiAgent other) {
        return this.sourceType.equals(other.sourceType) && this.sourceTitle.equals(other.sourceTitle) && this.lastAnswerType.equals(other.lastAnswerType) && this.resolutionState.equals(other.resolutionState) && this.rating.equals(other.rating) && this.ratingRemark.equals(other.ratingRemark) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.contentSources.equals(other.contentSources);
    }

    public int hashCode() {
        return Objects.hash(this.sourceType, this.sourceTitle, this.lastAnswerType, this.resolutionState, this.rating, this.ratingRemark, this.createdAt, this.updatedAt, this.contentSources);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class ResolutionState {
        public static final ResolutionState NEGATIVE_FEEDBACK = new ResolutionState(Value.NEGATIVE_FEEDBACK, "negative_feedback");
        public static final ResolutionState ASSUMED_RESOLUTION = new ResolutionState(Value.ASSUMED_RESOLUTION, "assumed_resolution");
        public static final ResolutionState ESCALATED = new ResolutionState(Value.ESCALATED, "escalated");
        public static final ResolutionState CONFIRMED_RESOLUTION = new ResolutionState(Value.CONFIRMED_RESOLUTION, "confirmed_resolution");
        public static final ResolutionState PROCEDURE_HANDOFF = new ResolutionState(Value.PROCEDURE_HANDOFF, "procedure_handoff");
        private final Value value;
        private final String string;

        ResolutionState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ResolutionState && this.string.equals(((ResolutionState)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case NEGATIVE_FEEDBACK: {
                    return visitor.visitNegativeFeedback();
                }
                case ASSUMED_RESOLUTION: {
                    return visitor.visitAssumedResolution();
                }
                case ESCALATED: {
                    return visitor.visitEscalated();
                }
                case CONFIRMED_RESOLUTION: {
                    return visitor.visitConfirmedResolution();
                }
                case PROCEDURE_HANDOFF: {
                    return visitor.visitProcedureHandoff();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static ResolutionState valueOf(String value) {
            switch (value) {
                case "negative_feedback": {
                    return NEGATIVE_FEEDBACK;
                }
                case "assumed_resolution": {
                    return ASSUMED_RESOLUTION;
                }
                case "escalated": {
                    return ESCALATED;
                }
                case "confirmed_resolution": {
                    return CONFIRMED_RESOLUTION;
                }
                case "procedure_handoff": {
                    return PROCEDURE_HANDOFF;
                }
            }
            return new ResolutionState(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitAssumedResolution();

            public T visitConfirmedResolution();

            public T visitEscalated();

            public T visitNegativeFeedback();

            public T visitProcedureHandoff();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ASSUMED_RESOLUTION,
            CONFIRMED_RESOLUTION,
            ESCALATED,
            NEGATIVE_FEEDBACK,
            PROCEDURE_HANDOFF,
            UNKNOWN;

        }
    }

    public static final class SourceType {
        public static final SourceType WORKFLOW = new SourceType(Value.WORKFLOW, "workflow");
        public static final SourceType WORKFLOW_PREVIEW = new SourceType(Value.WORKFLOW_PREVIEW, "workflow_preview");
        public static final SourceType FIN_PREVIEW = new SourceType(Value.FIN_PREVIEW, "fin_preview");
        public static final SourceType ESSENTIALS_PLAN_SETUP = new SourceType(Value.ESSENTIALS_PLAN_SETUP, "essentials_plan_setup");
        public static final SourceType PROFILE = new SourceType(Value.PROFILE, "profile");
        private final Value value;
        private final String string;

        SourceType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SourceType && this.string.equals(((SourceType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case WORKFLOW: {
                    return visitor.visitWorkflow();
                }
                case WORKFLOW_PREVIEW: {
                    return visitor.visitWorkflowPreview();
                }
                case FIN_PREVIEW: {
                    return visitor.visitFinPreview();
                }
                case ESSENTIALS_PLAN_SETUP: {
                    return visitor.visitEssentialsPlanSetup();
                }
                case PROFILE: {
                    return visitor.visitProfile();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static SourceType valueOf(String value) {
            switch (value) {
                case "workflow": {
                    return WORKFLOW;
                }
                case "workflow_preview": {
                    return WORKFLOW_PREVIEW;
                }
                case "fin_preview": {
                    return FIN_PREVIEW;
                }
                case "essentials_plan_setup": {
                    return ESSENTIALS_PLAN_SETUP;
                }
                case "profile": {
                    return PROFILE;
                }
            }
            return new SourceType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitEssentialsPlanSetup();

            public T visitProfile();

            public T visitWorkflow();

            public T visitWorkflowPreview();

            public T visitFinPreview();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ESSENTIALS_PLAN_SETUP,
            PROFILE,
            WORKFLOW,
            WORKFLOW_PREVIEW,
            FIN_PREVIEW,
            UNKNOWN;

        }
    }

    public static final class LastAnswerType {
        public static final LastAnswerType AI_ANSWER = new LastAnswerType(Value.AI_ANSWER, "ai_answer");
        public static final LastAnswerType CUSTOM_ANSWER = new LastAnswerType(Value.CUSTOM_ANSWER, "custom_answer");
        private final Value value;
        private final String string;

        LastAnswerType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof LastAnswerType && this.string.equals(((LastAnswerType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case AI_ANSWER: {
                    return visitor.visitAiAnswer();
                }
                case CUSTOM_ANSWER: {
                    return visitor.visitCustomAnswer();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static LastAnswerType valueOf(String value) {
            switch (value) {
                case "ai_answer": {
                    return AI_ANSWER;
                }
                case "custom_answer": {
                    return CUSTOM_ANSWER;
                }
            }
            return new LastAnswerType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitAiAnswer();

            public T visitCustomAnswer();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            AI_ANSWER,
            CUSTOM_ANSWER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<SourceType> sourceType = Optional.empty();
        private Optional<String> sourceTitle = Optional.empty();
        private Optional<LastAnswerType> lastAnswerType = Optional.empty();
        private Optional<ResolutionState> resolutionState = Optional.empty();
        private Optional<Integer> rating = Optional.empty();
        private Optional<String> ratingRemark = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<ContentSourcesList> contentSources = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AiAgent other) {
            this.sourceType(other.getSourceType());
            this.sourceTitle(other.getSourceTitle());
            this.lastAnswerType(other.getLastAnswerType());
            this.resolutionState(other.getResolutionState());
            this.rating(other.getRating());
            this.ratingRemark(other.getRatingRemark());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.contentSources(other.getContentSources());
            return this;
        }

        @JsonSetter(value="source_type", nulls=Nulls.SKIP)
        public Builder sourceType(Optional<SourceType> sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = Optional.ofNullable(sourceType);
            return this;
        }

        @JsonSetter(value="source_title", nulls=Nulls.SKIP)
        public Builder sourceTitle(Optional<String> sourceTitle) {
            this.sourceTitle = sourceTitle;
            return this;
        }

        public Builder sourceTitle(String sourceTitle) {
            this.sourceTitle = Optional.ofNullable(sourceTitle);
            return this;
        }

        @JsonSetter(value="last_answer_type", nulls=Nulls.SKIP)
        public Builder lastAnswerType(Optional<LastAnswerType> lastAnswerType) {
            this.lastAnswerType = lastAnswerType;
            return this;
        }

        public Builder lastAnswerType(LastAnswerType lastAnswerType) {
            this.lastAnswerType = Optional.ofNullable(lastAnswerType);
            return this;
        }

        @JsonSetter(value="resolution_state", nulls=Nulls.SKIP)
        public Builder resolutionState(Optional<ResolutionState> resolutionState) {
            this.resolutionState = resolutionState;
            return this;
        }

        public Builder resolutionState(ResolutionState resolutionState) {
            this.resolutionState = Optional.ofNullable(resolutionState);
            return this;
        }

        @JsonSetter(value="rating", nulls=Nulls.SKIP)
        public Builder rating(Optional<Integer> rating) {
            this.rating = rating;
            return this;
        }

        public Builder rating(Integer rating) {
            this.rating = Optional.ofNullable(rating);
            return this;
        }

        @JsonSetter(value="rating_remark", nulls=Nulls.SKIP)
        public Builder ratingRemark(Optional<String> ratingRemark) {
            this.ratingRemark = ratingRemark;
            return this;
        }

        public Builder ratingRemark(String ratingRemark) {
            this.ratingRemark = Optional.ofNullable(ratingRemark);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="content_sources", nulls=Nulls.SKIP)
        public Builder contentSources(Optional<ContentSourcesList> contentSources) {
            this.contentSources = contentSources;
            return this;
        }

        public Builder contentSources(ContentSourcesList contentSources) {
            this.contentSources = Optional.ofNullable(contentSources);
            return this;
        }

        public AiAgent build() {
            return new AiAgent(this.sourceType, this.sourceTitle, this.lastAnswerType, this.resolutionState, this.rating, this.ratingRemark, this.createdAt, this.updatedAt, this.contentSources, this.additionalProperties);
        }
    }
}

