/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.messages;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.messages.AsyncRawMessagesClient;
import com.intercom.api.resources.unstable.messages.requests.GetWhatsAppMessageStatusRequest;
import com.intercom.api.resources.unstable.messages.types.Message;
import com.intercom.api.resources.unstable.types.WhatsappMessageStatusList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncMessagesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawMessagesClient rawClient;

    public AsyncMessagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawMessagesClient(clientOptions);
    }

    public AsyncRawMessagesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Message> createMessage() {
        return this.rawClient.createMessage().thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<Message> createMessage(Optional<Object> request) {
        return this.rawClient.createMessage(request).thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<Message> createMessage(Optional<Object> request, RequestOptions requestOptions) {
        return this.rawClient.createMessage(request, requestOptions).thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<WhatsappMessageStatusList> getWhatsAppMessageStatus(GetWhatsAppMessageStatusRequest request) {
        return this.rawClient.getWhatsAppMessageStatus(request).thenApply(response -> (WhatsappMessageStatusList)response.body());
    }

    public CompletableFuture<WhatsappMessageStatusList> getWhatsAppMessageStatus(GetWhatsAppMessageStatusRequest request, RequestOptions requestOptions) {
        return this.rawClient.getWhatsAppMessageStatus(request, requestOptions).thenApply(response -> (WhatsappMessageStatusList)response.body());
    }
}

