/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomActionFinished {
    private final Optional<Action> action;
    private final Map<String, Object> additionalProperties;

    private CustomActionFinished(Optional<Action> action, Map<String, Object> additionalProperties) {
        this.action = action;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="action")
    public Optional<Action> getAction() {
        return this.action;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomActionFinished && this.equalTo((CustomActionFinished)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomActionFinished other) {
        return this.action.equals(other.action);
    }

    public int hashCode() {
        return Objects.hash(this.action);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Action {
        private final Optional<String> name;
        private final Optional<Result> result;
        private final Map<String, Object> additionalProperties;

        private Action(Optional<String> name, Optional<Result> result, Map<String, Object> additionalProperties) {
            this.name = name;
            this.result = result;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        @JsonProperty(value="result")
        public Optional<Result> getResult() {
            return this.result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Action && this.equalTo((Action)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Action other) {
            return this.name.equals(other.name) && this.result.equals(other.result);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.result);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Result {
            public static final Result SUCCESS = new Result(Value.SUCCESS, "success");
            public static final Result FAILED = new Result(Value.FAILED, "failed");
            private final Value value;
            private final String string;

            Result(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return this.value;
            }

            @JsonValue
            public String toString() {
                return this.string;
            }

            public boolean equals(Object other) {
                return this == other || other instanceof Result && this.string.equals(((Result)other).string);
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (this.value) {
                    case SUCCESS: {
                        return visitor.visitSuccess();
                    }
                    case FAILED: {
                        return visitor.visitFailed();
                    }
                }
                return visitor.visitUnknown(this.string);
            }

            @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
            public static Result valueOf(String value) {
                switch (value) {
                    case "success": {
                        return SUCCESS;
                    }
                    case "failed": {
                        return FAILED;
                    }
                }
                return new Result(Value.UNKNOWN, value);
            }

            public static interface Visitor<T> {
                public T visitSuccess();

                public T visitFailed();

                public T visitUnknown(String var1);
            }

            public static enum Value {
                SUCCESS,
                FAILED,
                UNKNOWN;

            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();
            private Optional<Result> result = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Action other) {
                this.name(other.getName());
                this.result(other.getResult());
                return this;
            }

            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            @JsonSetter(value="result", nulls=Nulls.SKIP)
            public Builder result(Optional<Result> result) {
                this.result = result;
                return this;
            }

            public Builder result(Result result) {
                this.result = Optional.ofNullable(result);
                return this;
            }

            public Action build() {
                return new Action(this.name, this.result, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Action> action = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomActionFinished other) {
            this.action(other.getAction());
            return this;
        }

        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public Builder action(Optional<Action> action) {
            this.action = action;
            return this;
        }

        public Builder action(Action action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        public CustomActionFinished build() {
            return new CustomActionFinished(this.action, this.additionalProperties);
        }
    }
}

