/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.visitors;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.resources.visitors.AsyncRawVisitorsClient;
import com.intercom.api.resources.visitors.requests.FindVisitorRequest;
import com.intercom.api.resources.visitors.requests.MergeVisitorToContactRequest;
import com.intercom.api.types.UpdateVisitorRequest;
import com.intercom.api.types.Visitor;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncVisitorsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawVisitorsClient rawClient;

    public AsyncVisitorsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawVisitorsClient(clientOptions);
    }

    public AsyncRawVisitorsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Optional<Visitor>> find(FindVisitorRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Visitor>> find(FindVisitorRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Visitor>> update(UpdateVisitorRequest request) {
        return this.rawClient.update(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Visitor>> update(UpdateVisitorRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Contact> mergeToContact(MergeVisitorToContactRequest request) {
        return this.rawClient.mergeToContact(request).thenApply(response -> (Contact)response.body());
    }

    public CompletableFuture<Contact> mergeToContact(MergeVisitorToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.mergeToContact(request, requestOptions).thenApply(response -> (Contact)response.body());
    }
}

