/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PhoneSwitch {
    private final Optional<String> type;
    private final Optional<String> phone;
    private final Map<String, Object> additionalProperties;

    private PhoneSwitch(Optional<String> type, Optional<String> phone, Map<String, Object> additionalProperties) {
        this.type = type;
        this.phone = phone;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="phone")
    public Optional<String> getPhone() {
        return this.phone;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PhoneSwitch && this.equalTo((PhoneSwitch)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PhoneSwitch other) {
        return this.type.equals(other.type) && this.phone.equals(other.phone);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.phone);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> phone = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PhoneSwitch other) {
            this.type(other.getType());
            this.phone(other.getPhone());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="phone", nulls=Nulls.SKIP)
        public Builder phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public PhoneSwitch build() {
            return new PhoneSwitch(this.type, this.phone, this.additionalProperties);
        }
    }
}

