/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.node;

import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.internal.node.MavenCacheResolver;
import io.jooby.internal.node.NodeTaskRunner;
import io.jooby.node.NodeTask;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class NodeModule
implements Extension {
    protected final String nodeVersion;
    private Path workDirectory;
    private Path installDirectory;
    private List<Consumer<NodeTask>> commands = new ArrayList<Consumer<NodeTask>>();

    protected NodeModule(@Nonnull String nodeVersion) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "Node version required.");
    }

    @Nonnull
    public NodeModule workDirectory(@Nonnull Path workDirectory) {
        this.workDirectory = Objects.requireNonNull(workDirectory, "Work directory required.");
        return this;
    }

    @Nonnull
    public NodeModule installDirectory(@Nonnull Path installDirectory) {
        this.installDirectory = Objects.requireNonNull(installDirectory, "Install directory required.");
        return this;
    }

    @Nonnull
    public NodeModule execute(@Nonnull String cmd, String ... args) {
        this.commands.add(executor -> executor.execute(cmd, args));
        return this;
    }

    @Nonnull
    public NodeModule executeOnce(@Nonnull String cmd, String ... args) {
        this.commands.add(executor -> executor.executeOnce(cmd, args));
        return this;
    }

    public void install(@Nonnull Jooby application) throws Exception {
        boolean enabled;
        Config conf = application.getConfig().withFallback((ConfigMergeable)ConfigFactory.parseResources(this.getClass(), (String)"node.conf"));
        Path userdir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path workdir = Optional.ofNullable(this.workDirectory).orElse(userdir);
        String name = this.getClass().getSimpleName().replace("Module", "").toLowerCase();
        boolean bl = Files.exists(workdir.resolve("package.json"), new LinkOption[0]) && (conf.hasPath(name + ".enabled") ? conf.getBoolean(name + ".enabled") : application.getEnvironment().isActive("dev", new String[]{"test"})) ? true : (enabled = false);
        if (enabled) {
            Path installdir = Optional.ofNullable(this.installDirectory).orElse(workdir);
            ProxyConfig proxy = new ProxyConfig(NodeModule.proxies(conf));
            MavenCacheResolver cache = Files.exists(userdir.resolve("pom.xml"), new LinkOption[0]) ? new MavenCacheResolver() : null;
            FrontendPluginFactory factory = new FrontendPluginFactory(workdir.toFile(), installdir.toFile(), (CacheResolver)cache);
            this.installNode(conf, this.nodeVersion, proxy, factory);
            application.onStarted(() -> {
                Map<String, String> environment = NodeModule.environment(application);
                NodeTaskRunner runner = this.newTaskRunner(factory, application.getEnvironment(), proxy);
                NodeTask task = (cmd, args) -> {
                    StringBuilder cmdline = new StringBuilder(cmd).append(" ");
                    Stream.of(args).forEach(arg -> cmdline.append((String)arg).append(" "));
                    String command = cmdline.toString().trim();
                    Thread thread = new Thread(() -> {
                        try {
                            runner.execute(command, environment);
                        }
                        catch (Exception x) {
                            application.getLog().error("{} resulted in exception: {}", new Object[]{name, command, x});
                        }
                    }, command);
                    thread.setDaemon(true);
                    thread.start();
                };
                NodeModule.checkAndSyncPackageJson(workdir, application.getTmpdir(), task);
                if (this.commands.isEmpty()) {
                    task.execute("run", "build");
                } else {
                    this.commands.forEach(cmd -> cmd.accept(task));
                }
            });
        } else {
            application.getLog().debug("{} module is disabled", (Object)name);
        }
    }

    private static Map<String, String> environment(Jooby application) {
        Environment env = application.getEnvironment();
        HashMap<String, String> vars = new HashMap<String, String>(System.getenv());
        env.getConfig().entrySet().forEach(e -> vars.put((String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped().toString()));
        vars.put("NODE_ENV", env.isActive("dev", new String[]{"test"}) ? "development" : "production");
        Integer port = Optional.ofNullable(application.getServerOptions()).map(ServerOptions::getPort).orElse(ServerOptions.SERVER_PORT);
        vars.put("server.port", port.toString());
        vars.put("application.path", application.getContextPath());
        return vars;
    }

    private static void checkAndSyncPackageJson(Path workdir, Path tmpdir, NodeTask task) throws Exception {
        Path tmp = tmpdir.resolve("package.json");
        Files.createDirectories(tmp, new FileAttribute[0]);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] bytes = digest.digest(Files.readAllBytes(workdir.resolve("package.json")));
        String sha1 = Long.toHexString(UUID.nameUUIDFromBytes(bytes).getMostSignificantBits());
        Path lastSha1 = tmp.resolve(sha1);
        if (!Files.exists(lastSha1, new LinkOption[0]) || !Files.exists(workdir.resolve("node_modules"), new LinkOption[0])) {
            task.execute("install", new String[0]);
            try (Stream<Path> files = Files.walk(tmp, new FileVisitOption[0]);){
                files.filter(f -> !f.equals(tmp)).forEach((Consumer<Path>)SneakyThrows.throwingConsumer(Files::deleteIfExists));
            }
            Files.write(tmp.resolve(lastSha1), Collections.emptyList(), new OpenOption[0]);
        }
    }

    private void installNode(Config conf, String version, ProxyConfig proxy, FrontendPluginFactory factory) throws InstallationException {
        NodeInstaller installer = factory.getNodeInstaller(proxy).setNodeVersion(version).setNodeDownloadRoot(conf.getString("node.downloadRoot"));
        this.installNpm(installer);
        installer.install();
    }

    protected void installNpm(NodeInstaller node) {
    }

    private static List<ProxyConfig.Proxy> proxies(Config conf) {
        if (conf.hasPath("proxy")) {
            return Collections.singletonList(new ProxyConfig.Proxy(conf.getString("proxy.id"), conf.getString("proxy.protocol"), conf.getString("proxy.host"), conf.getInt("proxy.port"), conf.getString("proxy.username"), conf.getString("proxy.password"), conf.getString("proxy.nonProxyHosts")));
        }
        return Collections.emptyList();
    }

    protected abstract NodeTaskRunner newTaskRunner(FrontendPluginFactory var1, Environment var2, ProxyConfig var3) throws InstallationException;
}

