/**
 * Jooby https://jooby.io
 * Apache License Version 2.0 https://jooby.io/LICENSE.txt
 * Copyright 2014 Edgar Espina
 */
package io.jooby.node;

import javax.annotation.Nonnull;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Node task executor.
 *
 * @author edgar.
 * @since 2.8.0
 */
public interface NodeTask {
  /**
   * Run a task once per JVM instance. Specially created for joobyRun to supports application
   * restart (hot reload) and long running node processes (like a web server).
   *
   * @param cmd Command.
   * @param args Arguments.
   */
  default void executeOnce(@Nonnull String cmd, @Nonnull String... args) {
    String cmdline = cmd + Stream.of(args).collect(Collectors.joining(" "));
    String runkey = "frontend." + cmdline.replace(" ", ".");
    boolean run = Boolean.parseBoolean(System.getProperty(runkey, "true"));
    if (run) {
      execute(cmd, args);
      System.setProperty(runkey, "false");
    }
  }

  /**
   * Execute a node task (without blocking the caller thread).
   *
   * @param cmd Command.
   * @param args Arguments.
   */
  void execute(@Nonnull String cmd, @Nonnull String... args);
}
