/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.rxjava3;

import io.jooby.Context;
import io.jooby.Route;
import io.jooby.StatusCode;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;

public class RxSubscriber
implements MaybeObserver<Object>,
SingleObserver<Object> {
    private final Context context;
    private Disposable subscription;

    public RxSubscriber(Context context) {
        this.context = context;
    }

    public void onSubscribe(Disposable d) {
        this.subscription = d;
    }

    public void onSuccess(Object value) {
        this.after(this.context, value, null);
        this.context.render(value);
    }

    public void onError(Throwable x) {
        this.after(this.context, null, this.unwrap(x));
        this.context.sendError(x);
        this.subscription.dispose();
    }

    private Throwable unwrap(Throwable x) {
        if (x instanceof CompletionException && x.getCause() != null) {
            return x.getCause();
        }
        return x;
    }

    public void onComplete() {
        if (!this.context.isResponseStarted()) {
            this.context.send(StatusCode.NOT_FOUND);
        }
        this.subscription.dispose();
    }

    private void after(Context ctx, Object value, Throwable failure) {
        Route.After after = ctx.getRoute().getAfter();
        if (after != null) {
            try {
                after.apply(ctx, value, failure);
            }
            catch (Exception unexpected) {
                Logger log = ctx.getRouter().getLog();
                log.debug("After invocation resulted in exception", (Throwable)unexpected);
            }
        }
    }
}

