/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Box;
import io.objectbox.EntityInfo;
import io.objectbox.Property;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.exception.DbException;
import io.objectbox.query.EagerRelation;
import io.objectbox.query.Query;
import io.objectbox.query.QueryFilter;
import io.objectbox.relation.RelationInfo;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

public class QueryBuilder<T>
implements Closeable {
    public static final int DESCENDING = 1;
    public static final int CASE_SENSITIVE = 2;
    public static final int NULLS_LAST = 8;
    public static final int NULLS_ZERO = 16;
    public static final int UNSIGNED = 4;
    private final Box<T> box;
    private final long storeHandle;
    private long handle;
    private long lastCondition;
    private long lastPropertyCondition;
    private Operator combineNextWith = Operator.NONE;
    @Nullable
    private List<EagerRelation<T, ?>> eagerRelations;
    @Nullable
    private QueryFilter<T> filter;
    @Nullable
    private Comparator<T> comparator;
    private final boolean isSubQuery;

    private native long nativeCreate(long var1, String var3);

    private native void nativeDestroy(long var1);

    private native long nativeBuild(long var1);

    private native long nativeLink(long var1, long var3, int var5, int var6, int var7, int var8, boolean var9);

    private native void nativeOrder(long var1, int var3, int var4);

    private native long nativeCombine(long var1, long var3, long var5, boolean var7);

    private native void nativeSetParameterAlias(long var1, String var3);

    private native long nativeNull(long var1, int var3);

    private native long nativeNotNull(long var1, int var3);

    private native long nativeEqual(long var1, int var3, long var4);

    private native long nativeNotEqual(long var1, int var3, long var4);

    private native long nativeLess(long var1, int var3, long var4);

    private native long nativeGreater(long var1, int var3, long var4);

    private native long nativeBetween(long var1, int var3, long var4, long var6);

    private native long nativeIn(long var1, int var3, int[] var4, boolean var5);

    private native long nativeIn(long var1, int var3, long[] var4, boolean var5);

    private native long nativeEqual(long var1, int var3, String var4, boolean var5);

    private native long nativeNotEqual(long var1, int var3, String var4, boolean var5);

    private native long nativeContains(long var1, int var3, String var4, boolean var5);

    private native long nativeStartsWith(long var1, int var3, String var4, boolean var5);

    private native long nativeEndsWith(long var1, int var3, String var4, boolean var5);

    private native long nativeLess(long var1, int var3, String var4, boolean var5);

    private native long nativeGreater(long var1, int var3, String var4, boolean var5);

    private native long nativeIn(long var1, int var3, String[] var4, boolean var5);

    private native long nativeLess(long var1, int var3, double var4);

    private native long nativeGreater(long var1, int var3, double var4);

    private native long nativeBetween(long var1, int var3, double var4, double var6);

    private native long nativeEqual(long var1, int var3, byte[] var4);

    private native long nativeLess(long var1, int var3, byte[] var4);

    private native long nativeGreater(long var1, int var3, byte[] var4);

    @Internal
    public QueryBuilder(Box<T> box, long storeHandle, String entityName) {
        this.box = box;
        this.storeHandle = storeHandle;
        this.handle = this.nativeCreate(storeHandle, entityName);
        if (this.handle == 0L) {
            throw new DbException("Could not create native query builder");
        }
        this.isSubQuery = false;
    }

    private QueryBuilder(long storeHandle, long subQueryBuilderHandle) {
        this.box = null;
        this.storeHandle = storeHandle;
        this.handle = subQueryBuilderHandle;
        this.isSubQuery = true;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public synchronized void close() {
        if (this.handle != 0L) {
            long handleCopy = this.handle;
            this.handle = 0L;
            if (!this.isSubQuery) {
                this.nativeDestroy(handleCopy);
            }
        }
    }

    public Query<T> build() {
        this.verifyNotSubQuery();
        this.verifyHandle();
        if (this.combineNextWith != Operator.NONE) {
            throw new IllegalStateException("Incomplete logic condition. Use or()/and() between two conditions only.");
        }
        long queryHandle = this.nativeBuild(this.handle);
        if (queryHandle == 0L) {
            throw new DbException("Could not create native query");
        }
        Query<T> query = new Query<T>(this.box, queryHandle, this.eagerRelations, this.filter, this.comparator);
        this.close();
        return query;
    }

    private void verifyNotSubQuery() {
        if (this.isSubQuery) {
            throw new IllegalStateException("This call is not supported on sub query builders (links)");
        }
    }

    private void verifyHandle() {
        if (this.handle == 0L) {
            throw new IllegalStateException("This QueryBuilder has already been closed. Please use a new instance.");
        }
    }

    public QueryBuilder<T> order(Property<T> property) {
        return this.order(property, 0);
    }

    public QueryBuilder<T> orderDesc(Property<T> property) {
        return this.order(property, 1);
    }

    public QueryBuilder<T> order(Property<T> property, int flags) {
        this.verifyNotSubQuery();
        this.verifyHandle();
        if (this.combineNextWith != Operator.NONE) {
            throw new IllegalStateException("An operator is pending. Use operators like and() and or() only between two conditions.");
        }
        this.nativeOrder(this.handle, property.getId(), flags);
        return this;
    }

    public QueryBuilder<T> sort(Comparator<T> comparator) {
        this.comparator = comparator;
        return this;
    }

    public QueryBuilder<T> parameterAlias(String alias) {
        this.verifyHandle();
        if (this.lastPropertyCondition == 0L) {
            throw new IllegalStateException("No previous condition. Before you can assign an alias, you must first have a condition.");
        }
        this.nativeSetParameterAlias(this.lastPropertyCondition, alias);
        return this;
    }

    public <TARGET> QueryBuilder<TARGET> link(RelationInfo<?, TARGET> relationInfo) {
        boolean backlink = relationInfo.isBacklink();
        EntityInfo<Object> relationOwner = backlink ? relationInfo.targetInfo : relationInfo.sourceInfo;
        return this.link(relationInfo, relationOwner, relationInfo.targetInfo, backlink);
    }

    private <TARGET> QueryBuilder<TARGET> link(RelationInfo<?, ?> relationInfo, EntityInfo<?> relationOwner, EntityInfo<?> target, boolean backlink) {
        int propertyId = relationInfo.targetIdProperty != null ? relationInfo.targetIdProperty.id : 0;
        int relationId = relationInfo.targetRelationId != 0 ? relationInfo.targetRelationId : relationInfo.relationId;
        long linkQBHandle = this.nativeLink(this.handle, this.storeHandle, relationOwner.getEntityId(), target.getEntityId(), propertyId, relationId, backlink);
        return new QueryBuilder<T>(this.storeHandle, linkQBHandle);
    }

    public <TARGET> QueryBuilder<TARGET> backlink(RelationInfo<TARGET, ?> relationInfo) {
        if (relationInfo.isBacklink()) {
            throw new IllegalArgumentException("Double backlink: The relation is already a backlink, please use a regular link on the original relation instead.");
        }
        return this.link(relationInfo, relationInfo.sourceInfo, relationInfo.sourceInfo, true);
    }

    public QueryBuilder<T> eager(RelationInfo relationInfo, RelationInfo ... more) {
        return this.eager(0, relationInfo, more);
    }

    public QueryBuilder<T> eager(int limit, RelationInfo relationInfo, RelationInfo ... more) {
        this.verifyNotSubQuery();
        if (this.eagerRelations == null) {
            this.eagerRelations = new ArrayList();
        }
        this.eagerRelations.add(new EagerRelation(limit, relationInfo));
        if (more != null) {
            for (RelationInfo info : more) {
                this.eagerRelations.add(new EagerRelation(limit, info));
            }
        }
        return this;
    }

    public QueryBuilder<T> filter(QueryFilter<T> filter) {
        this.verifyNotSubQuery();
        if (this.filter != null) {
            throw new IllegalStateException("A filter was already defined, you can only assign one filter");
        }
        this.filter = filter;
        return this;
    }

    public QueryBuilder<T> or() {
        this.combineOperator(Operator.OR);
        return this;
    }

    public QueryBuilder<T> and() {
        this.combineOperator(Operator.AND);
        return this;
    }

    private void combineOperator(Operator operator) {
        if (this.lastCondition == 0L) {
            throw new IllegalStateException("No previous condition. Use operators like and() and or() only between two conditions.");
        }
        if (this.combineNextWith != Operator.NONE) {
            throw new IllegalStateException("Another operator is pending. Use operators like and() and or() only between two conditions.");
        }
        this.combineNextWith = operator;
    }

    private void checkCombineCondition(long currentCondition) {
        if (this.combineNextWith != Operator.NONE) {
            boolean combineUsingOr = this.combineNextWith == Operator.OR;
            this.lastCondition = this.nativeCombine(this.handle, this.lastCondition, currentCondition, combineUsingOr);
            this.combineNextWith = Operator.NONE;
        } else {
            this.lastCondition = currentCondition;
        }
        this.lastPropertyCondition = currentCondition;
    }

    public QueryBuilder<T> isNull(Property<T> property) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeNull(this.handle, property.getId()));
        return this;
    }

    public QueryBuilder<T> notNull(Property<T> property) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeNotNull(this.handle, property.getId()));
        return this;
    }

    public QueryBuilder<T> equal(Property<T> property, long value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeEqual(this.handle, property.getId(), value));
        return this;
    }

    public QueryBuilder<T> equal(Property<T> property, boolean value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeEqual(this.handle, property.getId(), value ? 1L : 0L));
        return this;
    }

    public QueryBuilder<T> equal(Property<T> property, Date value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeEqual(this.handle, property.getId(), value.getTime()));
        return this;
    }

    public QueryBuilder<T> notEqual(Property<T> property, long value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeNotEqual(this.handle, property.getId(), value));
        return this;
    }

    public QueryBuilder<T> notEqual(Property<T> property, boolean value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeNotEqual(this.handle, property.getId(), value ? 1L : 0L));
        return this;
    }

    public QueryBuilder<T> notEqual(Property<T> property, Date value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeNotEqual(this.handle, property.getId(), value.getTime()));
        return this;
    }

    public QueryBuilder<T> less(Property<T> property, long value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeLess(this.handle, property.getId(), value));
        return this;
    }

    public QueryBuilder<T> greater(Property<T> property, long value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeGreater(this.handle, property.getId(), value));
        return this;
    }

    public QueryBuilder<T> less(Property<T> property, Date value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeLess(this.handle, property.getId(), value.getTime()));
        return this;
    }

    public QueryBuilder<T> greater(Property<T> property, Date value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeGreater(this.handle, property.getId(), value.getTime()));
        return this;
    }

    public QueryBuilder<T> between(Property<T> property, long value1, long value2) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeBetween(this.handle, property.getId(), value1, value2));
        return this;
    }

    public QueryBuilder<T> between(Property<T> property, Date value1, Date value2) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeBetween(this.handle, property.getId(), value1.getTime(), value2.getTime()));
        return this;
    }

    public QueryBuilder<T> in(Property<T> property, long[] values) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeIn(this.handle, property.getId(), values, false));
        return this;
    }

    public QueryBuilder<T> in(Property<T> property, int[] values) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeIn(this.handle, property.getId(), values, false));
        return this;
    }

    public QueryBuilder<T> notIn(Property<T> property, long[] values) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeIn(this.handle, property.getId(), values, true));
        return this;
    }

    public QueryBuilder<T> notIn(Property<T> property, int[] values) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeIn(this.handle, property.getId(), values, true));
        return this;
    }

    public QueryBuilder<T> equal(Property<T> property, String value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeEqual(this.handle, property.getId(), value, false));
        return this;
    }

    public QueryBuilder<T> equal(Property<T> property, String value, StringOrder order) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeEqual(this.handle, property.getId(), value, order == StringOrder.CASE_SENSITIVE));
        return this;
    }

    public QueryBuilder<T> notEqual(Property<T> property, String value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeNotEqual(this.handle, property.getId(), value, false));
        return this;
    }

    public QueryBuilder<T> notEqual(Property<T> property, String value, StringOrder order) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeNotEqual(this.handle, property.getId(), value, order == StringOrder.CASE_SENSITIVE));
        return this;
    }

    public QueryBuilder<T> contains(Property<T> property, String value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeContains(this.handle, property.getId(), value, false));
        return this;
    }

    public QueryBuilder<T> startsWith(Property<T> property, String value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeStartsWith(this.handle, property.getId(), value, false));
        return this;
    }

    public QueryBuilder<T> endsWith(Property<T> property, String value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeEndsWith(this.handle, property.getId(), value, false));
        return this;
    }

    public QueryBuilder<T> contains(Property<T> property, String value, StringOrder order) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeContains(this.handle, property.getId(), value, order == StringOrder.CASE_SENSITIVE));
        return this;
    }

    public QueryBuilder<T> startsWith(Property<T> property, String value, StringOrder order) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeStartsWith(this.handle, property.getId(), value, order == StringOrder.CASE_SENSITIVE));
        return this;
    }

    public QueryBuilder<T> endsWith(Property<T> property, String value, StringOrder order) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeEndsWith(this.handle, property.getId(), value, order == StringOrder.CASE_SENSITIVE));
        return this;
    }

    public QueryBuilder<T> less(Property<T> property, String value) {
        return this.less(property, value, StringOrder.CASE_INSENSITIVE);
    }

    public QueryBuilder<T> less(Property<T> property, String value, StringOrder order) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeLess(this.handle, property.getId(), value, order == StringOrder.CASE_SENSITIVE));
        return this;
    }

    public QueryBuilder<T> greater(Property<T> property, String value) {
        return this.greater(property, value, StringOrder.CASE_INSENSITIVE);
    }

    public QueryBuilder<T> greater(Property<T> property, String value, StringOrder order) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeGreater(this.handle, property.getId(), value, order == StringOrder.CASE_SENSITIVE));
        return this;
    }

    public QueryBuilder<T> in(Property<T> property, String[] values) {
        return this.in(property, values, StringOrder.CASE_INSENSITIVE);
    }

    public QueryBuilder<T> in(Property<T> property, String[] values, StringOrder order) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeIn(this.handle, property.getId(), values, order == StringOrder.CASE_SENSITIVE));
        return this;
    }

    public QueryBuilder<T> equal(Property<T> property, double value, double tolerance) {
        return this.between(property, value - tolerance, value + tolerance);
    }

    public QueryBuilder<T> less(Property<T> property, double value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeLess(this.handle, property.getId(), value));
        return this;
    }

    public QueryBuilder<T> greater(Property<T> property, double value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeGreater(this.handle, property.getId(), value));
        return this;
    }

    public QueryBuilder<T> between(Property<T> property, double value1, double value2) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeBetween(this.handle, property.getId(), value1, value2));
        return this;
    }

    public QueryBuilder<T> equal(Property<T> property, byte[] value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeEqual(this.handle, property.getId(), value));
        return this;
    }

    public QueryBuilder<T> less(Property<T> property, byte[] value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeLess(this.handle, property.getId(), value));
        return this;
    }

    public QueryBuilder<T> greater(Property<T> property, byte[] value) {
        this.verifyHandle();
        this.checkCombineCondition(this.nativeGreater(this.handle, property.getId(), value));
        return this;
    }

    static enum Operator {
        NONE,
        AND,
        OR;

    }

    public static enum StringOrder {
        CASE_INSENSITIVE,
        CASE_SENSITIVE;

    }
}

