/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.BoxStore;
import io.objectbox.EntityInfo;
import io.objectbox.Factory;
import io.objectbox.TxCallback;
import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.config.FlatStoreOptions;
import io.objectbox.exception.DbException;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.ideasonly.ModelUpdate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.greenrobot.essentials.io.IoUtils;

public class BoxStoreBuilder {
    public static final String DEFAULT_NAME = "objectbox";
    public static final int DEFAULT_MAX_DB_SIZE_KBYTE = 0x100000;
    final byte[] model;
    File directory;
    private File baseDirectory;
    private String name;
    long maxSizeInKByte = 0x100000L;
    long maxDataSizeInKByte;
    @Nullable
    Object context;
    @Nullable
    Object relinker;
    ModelUpdate modelUpdate;
    int debugFlags;
    private boolean android;
    boolean debugRelations;
    int fileMode;
    int maxReaders;
    boolean noReaderThreadLocals;
    int queryAttempts;
    boolean skipReadSchema;
    boolean readOnly;
    boolean usePreviousCommit;
    short validateOnOpenModePages;
    long validateOnOpenPageLimit;
    short validateOnOpenModeKv;
    TxCallback<?> failedReadTxAttemptCallback;
    final List<EntityInfo<?>> entityInfoList = new ArrayList();
    private Factory<InputStream> initialDbFileFactory;

    @Internal
    public static BoxStoreBuilder createDebugWithoutModel() {
        BoxStoreBuilder builder = new BoxStoreBuilder();
        builder.skipReadSchema = true;
        return builder;
    }

    private BoxStoreBuilder() {
        this.model = null;
    }

    @Internal
    public BoxStoreBuilder(byte[] model) {
        if (model == null) {
            throw new IllegalArgumentException("Model may not be null");
        }
        this.model = Arrays.copyOf(model, model.length);
    }

    public BoxStoreBuilder name(String name) {
        if (this.directory != null) {
            throw new IllegalArgumentException("Already has directory, cannot assign name");
        }
        if (name.contains("/") || name.contains("\\")) {
            throw new IllegalArgumentException("Name may not contain (back) slashes. Use baseDirectory() or directory() to configure alternative directories");
        }
        this.name = name;
        return this;
    }

    public BoxStoreBuilder directory(File directory) {
        if (this.name != null) {
            throw new IllegalArgumentException("Already has name, cannot assign directory");
        }
        if (!this.android && this.baseDirectory != null) {
            throw new IllegalArgumentException("Already has base directory, cannot assign directory");
        }
        this.directory = directory;
        return this;
    }

    public BoxStoreBuilder baseDirectory(File baseDirectory) {
        if (this.directory != null) {
            throw new IllegalArgumentException("Already has directory, cannot assign base directory");
        }
        this.baseDirectory = baseDirectory;
        return this;
    }

    public BoxStoreBuilder androidContext(Object context) {
        if (context == null) {
            throw new NullPointerException("Context may not be null");
        }
        this.context = this.getApplicationContext(context);
        File baseDir = BoxStoreBuilder.getAndroidBaseDir(context);
        if (!baseDir.exists()) {
            baseDir.mkdir();
            if (!baseDir.exists()) {
                throw new RuntimeException("Could not init Android base dir at " + baseDir.getAbsolutePath());
            }
        }
        if (!baseDir.isDirectory()) {
            throw new RuntimeException("Android base dir is not a dir: " + baseDir.getAbsolutePath());
        }
        this.baseDirectory = baseDir;
        this.android = true;
        return this;
    }

    private Object getApplicationContext(Object context) {
        try {
            return context.getClass().getMethod("getApplicationContext", new Class[0]).invoke(context, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("context must be a valid Android Context", e);
        }
    }

    public BoxStoreBuilder androidReLinker(Object reLinkerInstance) {
        if (this.context == null) {
            throw new IllegalArgumentException("Set a Context using androidContext(context) first");
        }
        if (reLinkerInstance == null) {
            throw new NullPointerException("ReLinkerInstance may not be null");
        }
        this.relinker = reLinkerInstance;
        return this;
    }

    static File getAndroidDbDir(Object context, @Nullable String dbName) {
        File baseDir = BoxStoreBuilder.getAndroidBaseDir(context);
        return new File(baseDir, BoxStoreBuilder.dbName(dbName));
    }

    private static String dbName(@Nullable String dbNameOrNull) {
        return dbNameOrNull != null ? dbNameOrNull : DEFAULT_NAME;
    }

    static File getAndroidBaseDir(Object context) {
        return new File(BoxStoreBuilder.getAndroidFilesDir(context), DEFAULT_NAME);
    }

    @Nonnull
    private static File getAndroidFilesDir(Object context) {
        File filesDir;
        try {
            Method getFilesDir = context.getClass().getMethod("getFilesDir", new Class[0]);
            filesDir = (File)getFilesDir.invoke(context, new Object[0]);
            if (filesDir == null) {
                System.err.println("getFilesDir() returned null - retrying once...");
                filesDir = (File)getFilesDir.invoke(context, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not init with given Android context (must be sub class of android.content.Context)", e);
        }
        if (filesDir == null) {
            throw new IllegalStateException("Android files dir is null");
        }
        if (!filesDir.exists()) {
            throw new IllegalStateException("Android files dir does not exist");
        }
        return filesDir;
    }

    public BoxStoreBuilder fileMode(int mode) {
        this.fileMode = mode;
        return this;
    }

    public BoxStoreBuilder maxReaders(int maxReaders) {
        this.maxReaders = maxReaders;
        return this;
    }

    public BoxStoreBuilder noReaderThreadLocals() {
        this.noReaderThreadLocals = true;
        return this;
    }

    @Internal
    public void entity(EntityInfo<?> entityInfo) {
        this.entityInfoList.add(entityInfo);
    }

    BoxStoreBuilder modelUpdate(ModelUpdate modelUpdate) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public BoxStoreBuilder maxSizeInKByte(long maxSizeInKByte) {
        if (maxSizeInKByte <= this.maxDataSizeInKByte) {
            throw new IllegalArgumentException("maxSizeInKByte must be larger than maxDataSizeInKByte.");
        }
        this.maxSizeInKByte = maxSizeInKByte;
        return this;
    }

    @Experimental
    public BoxStoreBuilder maxDataSizeInKByte(long maxDataSizeInKByte) {
        if (maxDataSizeInKByte >= this.maxSizeInKByte) {
            throw new IllegalArgumentException("maxDataSizeInKByte must be smaller than maxSizeInKByte.");
        }
        this.maxDataSizeInKByte = maxDataSizeInKByte;
        return this;
    }

    public BoxStoreBuilder readOnly() {
        this.readOnly = true;
        return this;
    }

    public BoxStoreBuilder usePreviousCommit() {
        this.usePreviousCommit = true;
        return this;
    }

    public BoxStoreBuilder validateOnOpen(short validateOnOpenModePages) {
        if (validateOnOpenModePages < 1 || validateOnOpenModePages > 5) {
            throw new IllegalArgumentException("Must be one of ValidateOnOpenModePages");
        }
        this.validateOnOpenModePages = validateOnOpenModePages;
        return this;
    }

    public BoxStoreBuilder validateOnOpenPageLimit(long limit) {
        if (this.validateOnOpenModePages != 2 && this.validateOnOpenModePages != 3) {
            throw new IllegalStateException("Must call validateOnOpen(mode) with mode Regular or WithLeaves first");
        }
        if (limit < 1L) {
            throw new IllegalArgumentException("limit must be positive");
        }
        this.validateOnOpenPageLimit = limit;
        return this;
    }

    public BoxStoreBuilder validateOnOpenKv() {
        this.validateOnOpenModeKv = 1;
        return this;
    }

    public BoxStoreBuilder validateOnOpenKv(short mode) {
        if (mode < 1 || mode > 1) {
            throw new IllegalArgumentException("Must be one of ValidateOnOpenModeKv");
        }
        this.validateOnOpenModeKv = mode;
        return this;
    }

    @Deprecated
    public BoxStoreBuilder debugTransactions() {
        this.debugFlags |= 3;
        return this;
    }

    public BoxStoreBuilder debugFlags(int debugFlags) {
        this.debugFlags = debugFlags;
        return this;
    }

    public BoxStoreBuilder debugRelations() {
        this.debugRelations = true;
        return this;
    }

    @Experimental
    public BoxStoreBuilder queryAttempts(int queryAttempts) {
        if (queryAttempts < 1) {
            throw new IllegalArgumentException("Query attempts must >= 1");
        }
        this.queryAttempts = queryAttempts;
        return this;
    }

    @Experimental
    public BoxStoreBuilder failedReadTxAttemptCallback(TxCallback<?> failedReadTxAttemptCallback) {
        this.failedReadTxAttemptCallback = failedReadTxAttemptCallback;
        return this;
    }

    @Experimental
    public BoxStoreBuilder initialDbFile(File initialDbFile) {
        return this.initialDbFile(() -> new FileInputStream(initialDbFile));
    }

    @Experimental
    public BoxStoreBuilder initialDbFile(Factory<InputStream> initialDbFileFactory) {
        this.initialDbFileFactory = initialDbFileFactory;
        return this;
    }

    byte[] buildFlatStoreOptions(String canonicalPath) {
        FlatBufferBuilder fbb = new FlatBufferBuilder();
        fbb.forceDefaults(true);
        int directoryPathOffset = fbb.createString(canonicalPath);
        FlatStoreOptions.startFlatStoreOptions(fbb);
        FlatStoreOptions.addDirectoryPath(fbb, directoryPathOffset);
        FlatStoreOptions.addMaxDbSizeInKbyte(fbb, this.maxSizeInKByte);
        FlatStoreOptions.addFileMode(fbb, this.fileMode);
        FlatStoreOptions.addMaxReaders(fbb, this.maxReaders);
        if (this.validateOnOpenModePages != 0) {
            FlatStoreOptions.addValidateOnOpenPages(fbb, this.validateOnOpenModePages);
            if (this.validateOnOpenPageLimit != 0L) {
                FlatStoreOptions.addValidateOnOpenPageLimit(fbb, this.validateOnOpenPageLimit);
            }
        }
        if (this.validateOnOpenModeKv != 0) {
            FlatStoreOptions.addValidateOnOpenKv(fbb, this.validateOnOpenModeKv);
        }
        if (this.skipReadSchema) {
            FlatStoreOptions.addSkipReadSchema(fbb, true);
        }
        if (this.usePreviousCommit) {
            FlatStoreOptions.addUsePreviousCommit(fbb, true);
        }
        if (this.readOnly) {
            FlatStoreOptions.addReadOnly(fbb, true);
        }
        if (this.noReaderThreadLocals) {
            FlatStoreOptions.addNoReaderThreadLocals(fbb, true);
        }
        if (this.debugFlags != 0) {
            FlatStoreOptions.addDebugFlags(fbb, this.debugFlags);
        }
        if (this.maxDataSizeInKByte > 0L) {
            FlatStoreOptions.addMaxDataSizeInKbyte(fbb, this.maxDataSizeInKByte);
        }
        int offset = FlatStoreOptions.endFlatStoreOptions(fbb);
        fbb.finish(offset);
        return fbb.sizedByteArray();
    }

    public BoxStore build() {
        if (this.directory == null) {
            this.name = BoxStoreBuilder.dbName(this.name);
            this.directory = BoxStoreBuilder.getDbDir(this.baseDirectory, this.name);
        }
        this.checkProvisionInitialDbFile();
        return new BoxStore(this);
    }

    private void checkProvisionInitialDbFile() {
        String dataDir;
        File file;
        if (this.initialDbFileFactory != null && !(file = new File(dataDir = BoxStore.getCanonicalPath(this.directory), "data.mdb")).exists()) {
            InputStream in = null;
            BufferedOutputStream out = null;
            try {
                in = this.initialDbFileFactory.provide();
                if (in == null) {
                    throw new DbException("Factory did not provide a resource");
                }
                in = new BufferedInputStream(in);
                out = new BufferedOutputStream(new FileOutputStream(file));
                IoUtils.copyAllBytes((InputStream)in, (OutputStream)out);
            }
            catch (Exception e) {
                try {
                    throw new DbException("Could not provision initial data file", e);
                }
                catch (Throwable throwable) {
                    IoUtils.safeClose(out);
                    IoUtils.safeClose((Closeable)in);
                    throw throwable;
                }
            }
            IoUtils.safeClose((Closeable)out);
            IoUtils.safeClose((Closeable)in);
        }
    }

    static File getDbDir(@Nullable File baseDirectoryOrNull, @Nullable String nameOrNull) {
        String name = BoxStoreBuilder.dbName(nameOrNull);
        if (baseDirectoryOrNull != null) {
            return new File(baseDirectoryOrNull, name);
        }
        return new File(name);
    }

    public BoxStore buildDefault() {
        BoxStore store = this.build();
        BoxStore.setDefault(store);
        return store;
    }
}

