/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.dsl;

import io.simplesource.api.Aggregator;
import java.util.HashMap;
import java.util.Map;

public final class AggregatorBuilder<E, A> {
    private final Map<Class<? extends E>, Aggregator<? extends E, A>> aggregators = new HashMap<Class<? extends E>, Aggregator<? extends E, A>>();

    public static <E, A> AggregatorBuilder<E, A> newBuilder() {
        return new AggregatorBuilder<E, A>();
    }

    private AggregatorBuilder() {
    }

    public <SE extends E> AggregatorBuilder<E, A> onEvent(Class<SE> specificEventClass, Aggregator<SE, A> ch) {
        this.aggregators.put(specificEventClass, ch);
        return this;
    }

    private Map<Class<? extends E>, Aggregator<? extends E, A>> getAggregators() {
        return new HashMap<Class<? extends E>, Aggregator<? extends E, A>>(this.aggregators);
    }

    public Aggregator<E, A> build() {
        Map eh = this.getAggregators();
        return (currentAggregate, event) -> {
            Aggregator eventHandler = (Aggregator)eh.get(event.getClass());
            if (eventHandler == null) {
                throw new IllegalStateException(String.format("Unhandled event type: %s", event.getClass().getSimpleName()));
            }
            return eventHandler.applyEvent(currentAggregate, event);
        };
    }
}

