/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.eclipse.projectsettings.ProjectProperties;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFiles;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class ProjectSettingsFilesTests {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void iteratorIteratesFiles() throws Exception {
        ProjectSettingsFile file = ProjectSettingsFile.fromFile((File)this.temp.newFile());
        ProjectSettingsFiles files = new ProjectSettingsFiles(Collections.singleton(file), new ProjectProperties());
        Assertions.assertThat((Iterable)files).containsOnly((Object[])new ProjectSettingsFile[]{file});
    }

    @Test
    public void applyToProjectCopiesToDotSettings() throws Exception {
        ProjectSettingsFile file = ProjectSettingsFile.fromFile((File)this.temp.newFile("foo.prefs"));
        ProjectSettingsFiles files = new ProjectSettingsFiles(Collections.singleton(file), new ProjectProperties());
        IProject project = (IProject)Mockito.mock(IProject.class);
        IProgressMonitor monitor = (IProgressMonitor)Mockito.mock(IProgressMonitor.class);
        IFile projectFile = (IFile)Mockito.mock(IFile.class);
        BDDMockito.given((Object)project.getFile(".settings/foo.prefs")).willReturn((Object)projectFile);
        BDDMockito.given((Object)projectFile.exists()).willReturn((Object)true);
        files.applyToProject(project, monitor);
        ((IFile)Mockito.verify((Object)projectFile)).setContents((InputStream)ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (IProgressMonitor)ArgumentMatchers.eq((Object)monitor));
    }
}

