/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.m2e.gradle;

import com.google.common.base.Optional;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import io.spring.javaformat.eclipse.Executor;
import io.spring.javaformat.eclipse.Messages;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFilesLocator;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.GradleWorkspaceManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;

public class RefreshProjectsSettingsJob
extends Job {
    private static final Object TASK_NAME = "formatcheckMain";
    private final CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();

    public RefreshProjectsSettingsJob() {
        super("Refresh spring-javaformat project settings");
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            new Executor(Messages.springFormatSettingsImportError).run(() -> this.configureProjects(monitor));
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
        return Status.OK_STATUS;
    }

    private void configureProjects(IProgressMonitor monitor) throws CoreException, IOException {
        GradleWorkspaceManager manager = CorePlugin.gradleWorkspaceManager();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            Optional build = manager.getGradleBuild(project);
            if (build.isPresent()) {
                this.configureProject(project, (GradleBuild)build.get(), monitor);
            }
            ++n2;
        }
    }

    private void configureProject(IProject project, GradleBuild build, IProgressMonitor monitor) throws CoreException, IOException {
        Set projects = build.getModelProvider().fetchEclipseGradleProjects(FetchStrategy.FORCE_RELOAD, this.tokenSource.token(), monitor);
        if (this.hasSpringFormatPlugin(projects)) {
            ProjectSettingsFilesLocator locator = new ProjectSettingsFilesLocator(this.getSearchFolders(projects));
            locator.locateSettingsFiles().applyToProject(project, monitor);
        }
    }

    private boolean hasSpringFormatPlugin(Set<OmniEclipseProject> projects) {
        for (OmniEclipseProject project : projects) {
            for (OmniProjectTask task : project.getGradleProject().getProjectTasks()) {
                if (!this.isSpringFormatPlugin(task)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpringFormatPlugin(OmniProjectTask task) {
        return TASK_NAME.equals(task.getName());
    }

    private Set<File> getSearchFolders(Set<OmniEclipseProject> projects) {
        LinkedHashSet<File> searchFolders = new LinkedHashSet<File>();
        for (OmniEclipseProject project : projects) {
            searchFolders.add(project.getProjectDirectory());
            searchFolders.add(project.getRoot().getProjectDirectory());
        }
        return searchFolders;
    }
}

