/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Executor {
    private final String failureMessage;

    public Executor(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public void run(Command command) throws CoreException {
        try {
            command.run();
        }
        catch (Exception ex) {
            if (ex instanceof CoreException) {
                throw (CoreException)ex;
            }
            String msg = NLS.bind((String)this.failureMessage, (Object)ex.getMessage());
            throw new CoreException((IStatus)new Status(4, "io.spring.javaformat.eclipse", -1, msg, (Throwable)ex));
        }
    }

    public static interface Command {
        public void run() throws Exception;
    }
}

