/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.eclipse.projectsettings.ProjectProperties;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectSettingsFiles
implements Iterable<ProjectSettingsFile> {
    private final List<ProjectSettingsFile> files;
    private final ProjectProperties projectProperties;

    public ProjectSettingsFiles(Collection<ProjectSettingsFile> files, ProjectProperties projectProperties) {
        this.files = new ArrayList<ProjectSettingsFile>(files);
        this.projectProperties = projectProperties;
    }

    @Override
    public Iterator<ProjectSettingsFile> iterator() {
        return this.files.iterator();
    }

    public void applyToProject(IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        JavaFormatConfig javaFormatConfig = this.getJavaFormatConfig(project);
        for (ProjectSettingsFile file : this) {
            file = this.projectProperties.getModifiedContent(file);
            IFile destination = project.getFile(".settings/" + file.getName());
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream content = file.getContent(javaFormatConfig);){
                if (!destination.exists()) {
                    destination.create((InputStream)new BufferedInputStream(content), true, monitor);
                    continue;
                }
                OrderedProperties properties = new OrderedProperties();
                Throwable throwable2 = null;
                Object var12_15 = null;
                try (InputStream existingContent = destination.getContents(true);){
                    if (existingContent != null) {
                        properties.load(existingContent);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                properties.load(content);
                destination.setContents((InputStream)new ByteArrayInputStream(this.stripTimestamp(properties).getBytes(StandardCharsets.UTF_8)), 1, monitor);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private String stripTimestamp(Properties properties) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            properties.store(output, null);
            String string = output.toString(StandardCharsets.UTF_8);
            String separator = System.getProperty("line.separator");
            return string.substring(string.indexOf(separator) + separator.length());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private JavaFormatConfig getJavaFormatConfig(IProject project) {
        try {
            IPath location = project.getLocation();
            File file = location != null ? location.toFile() : null;
            return JavaFormatConfig.findFrom((File)file);
        }
        catch (Exception exception) {
            return JavaFormatConfig.DEFAULT;
        }
    }

    private static class MapEntryKeyComparator
    implements Comparator<Map.Entry<Object, Object>> {
        private MapEntryKeyComparator() {
        }

        @Override
        public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
            Object k1 = o1.getKey();
            Object k2 = o2.getKey();
            return String.valueOf(k1).compareTo(String.valueOf(k2));
        }
    }

    static class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        OrderedProperties() {
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            TreeSet<Map.Entry<Object, Object>> set = new TreeSet<Map.Entry<Object, Object>>(new MapEntryKeyComparator());
            set.addAll(super.entrySet());
            return set;
        }
    }
}

