/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.scriptcontroller.closable.CompositeAutoClosable;
import me.lucko.scriptcontroller.environment.loader.EnvironmentScriptLoader;
import me.lucko.scriptcontroller.environment.registry.ScriptRegistry;
import me.lucko.scriptcontroller.environment.script.Script;
import me.lucko.scriptcontroller.internal.ScriptEnvironmentImpl;
import me.lucko.scriptcontroller.internal.ScriptImpl;
import me.lucko.scriptcontroller.logging.SystemLogger;

class ScriptLoaderImpl
implements EnvironmentScriptLoader {
    private static final WatchEvent.Kind<?>[] EVENTS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private final ScriptEnvironmentImpl environment;
    private final WatchService watchService;
    private final List<WatchKey> watchKeys = new CopyOnWriteArrayList<WatchKey>();
    private List<Path> files = new ArrayList<Path>();
    private final ReentrantLock lock = new ReentrantLock();

    public ScriptLoaderImpl(ScriptEnvironmentImpl environment) throws IOException {
        this.environment = environment;
        this.watchService = environment.getDirectory().getFileSystem().newWatchService();
        try (Stream<Path> dirs = Files.walk(environment.getDirectory(), new FileVisitOption[0]);){
            List directories = dirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            for (Path dir : directories) {
                this.watchKeys.add(dir.register(this.watchService, EVENTS));
            }
        }
    }

    @Override
    public ScriptEnvironmentImpl getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watchAll(Collection<String> paths) {
        this.lock.lock();
        try {
            for (String s : paths) {
                this.files.add(Paths.get(s, new String[0]));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unwatchAll(Collection<String> paths) {
        this.lock.lock();
        try {
            for (String s : paths) {
                this.files.remove(Paths.get(s, new String[0]));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void preload() {
        int filesLength;
        do {
            filesLength = this.files.size();
            this.reload(true);
        } while (filesLength != this.files.size());
    }

    @Override
    public void run() {
        this.lock.lock();
        try {
            this.reload(false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void reload(boolean runImmediately) {
        ScriptRegistry registry = this.environment.getScriptRegistry();
        SystemLogger logger = this.environment.getController().getLogger();
        LinkedHashSet<Path> toReload = new LinkedHashSet<Path>();
        LinkedHashSet<Path> toLoad = new LinkedHashSet<Path>();
        LinkedHashSet<Script> toUnload = new LinkedHashSet<Script>();
        this.checkWatched(toLoad, toUnload);
        this.checkRegistry(toUnload);
        this.checkFilesystem(toLoad, toUnload, toReload);
        LinkedHashSet<Path> reloadQueue = new LinkedHashSet<Path>();
        for (Path p : toReload) {
            this.resolveDepends(reloadQueue, p);
        }
        HashSet<Script> toTerminate = new HashSet<Script>();
        HashSet<ScriptImpl> toRun = new HashSet<ScriptImpl>();
        for (Path path : reloadQueue) {
            Script oldScript = registry.getScript(path);
            if (oldScript == null) continue;
            toTerminate.add(oldScript);
            ScriptImpl newScript = new ScriptImpl(this, path);
            registry.register(newScript);
            toRun.add(newScript);
            logger.info("[LOADER] Reloaded script: " + ScriptLoaderImpl.pathToString(path));
        }
        for (Path path : toLoad) {
            if (registry.getScript(path) != null) continue;
            ScriptImpl script = new ScriptImpl(this, path);
            registry.register(script);
            toRun.add(script);
            logger.info("[LOADER] Loaded script: " + ScriptLoaderImpl.pathToString(path));
        }
        for (Script s : toUnload) {
            registry.unregister(s);
            toTerminate.add(s);
            logger.info("[LOADER] Unloaded script: " + ScriptLoaderImpl.pathToString(s.getPath()));
        }
        if (toTerminate.isEmpty() && toRun.isEmpty()) {
            return;
        }
        Executor runExecutor = runImmediately ? Runnable::run : this.environment.getSettings().getRunExecutor();
        runExecutor.execute(() -> {
            CompositeAutoClosable.create().bindAll(toTerminate).closeAndReportExceptions();
            for (ScriptImpl script : toRun) {
                try {
                    script.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void checkWatched(Set<Path> toLoad, Set<Script> toUnload) {
        Path directory = this.environment.getDirectory();
        ScriptRegistry registry = this.environment.getScriptRegistry();
        for (Path path : this.files) {
            Script script = registry.getScript(path);
            if (Files.exists(directory.resolve(path), new LinkOption[0])) {
                if (script != null) continue;
                toLoad.add(path);
                continue;
            }
            if (script == null) continue;
            toUnload.add(script);
        }
    }

    private void checkRegistry(Set<Script> toUnload) {
        ScriptRegistry registry = this.environment.getScriptRegistry();
        for (Map.Entry<Path, Script> script : registry.getAll().entrySet()) {
            if (this.files.contains(script.getKey())) continue;
            toUnload.add(script.getValue());
        }
    }

    private void checkFilesystem(Set<Path> toLoad, Set<Script> toUnload, Set<Path> toReload) {
        Path directory = this.environment.getDirectory();
        ScriptRegistry registry = this.environment.getScriptRegistry();
        SystemLogger logger = this.environment.getController().getLogger();
        HashSet<Path> tryUnload = new HashSet<Path>();
        Iterator<WatchKey> keys = this.watchKeys.iterator();
        while (keys.hasNext()) {
            WatchKey key = keys.next();
            for (WatchEvent<?> event : key.pollEvents()) {
                Path context = (Path)event.context();
                if (context == null) continue;
                Path keyPath = (Path)key.watchable();
                Path fullPath = keyPath.resolve(context);
                Path relativePath = directory.relativize(fullPath);
                if (Files.isDirectory(fullPath, new LinkOption[0]) && !fullPath.getFileName().toString().equals("New folder")) {
                    logger.info("[LOADER] New directory detected at: " + relativePath.toString());
                }
                if (toLoad.contains(relativePath) || toUnload.stream().anyMatch(s -> s.getPath().equals(relativePath))) continue;
                if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                    tryUnload.add(relativePath);
                    continue;
                }
                Script script = registry.getScript(relativePath);
                if (script == null) {
                    if (this.files.contains(relativePath)) {
                        toLoad.add(relativePath);
                        continue;
                    }
                    toReload.add(relativePath);
                    continue;
                }
                toReload.add(script.getPath());
            }
            boolean valid = key.reset();
            if (valid) continue;
            logger.warning("[LOADER] Watch key is no longer valid: " + key.watchable().toString());
            keys.remove();
        }
        for (Path p : tryUnload) {
            Script script = registry.getScript(p);
            if (script == null || toLoad.contains(p) || toReload.contains(p)) continue;
            toUnload.add(script);
        }
    }

    private void resolveDepends(Set<Path> accumulator, Path path) {
        if (!accumulator.add(path)) {
            return;
        }
        for (Script other : this.environment.getScriptRegistry().getAll().values()) {
            if (!other.getDependencies().contains(path)) continue;
            this.resolveDepends(accumulator, other.getPath());
        }
    }

    @Override
    public void close() throws IOException {
        this.watchKeys.clear();
        this.watchService.close();
        this.files.clear();
    }

    private static String pathToString(Path path) {
        return path.toString().replace("\\", "/");
    }
}

