/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.logging;

import me.lucko.scriptcontroller.environment.script.Script;
import me.lucko.scriptcontroller.logging.ScriptLogger;
import me.lucko.scriptcontroller.logging.SystemLogger;

final class ScriptLoggerImpl
implements ScriptLogger {
    private static final String FORMAT = "[%s]%s";
    private final SystemLogger logger;
    private final Script script;

    public ScriptLoggerImpl(SystemLogger logger, Script script) {
        this.logger = logger;
        this.script = script;
    }

    @Override
    public void info(Object ... message) {
        this.logger.info(this.formatLog(message));
    }

    @Override
    public void warn(Object ... message) {
        this.logger.warning(this.formatLog(message));
    }

    @Override
    public void error(Object ... message) {
        this.logger.severe(this.formatLog(message));
    }

    private String formatLog(Object ... message) {
        return String.format(FORMAT, this.script.getName(), ScriptLoggerImpl.format(message));
    }

    private static String format(Object[] message) {
        if (message == null || message.length == 0) {
            return " ";
        }
        if (message.length == 1) {
            return " " + String.valueOf(message[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : message) {
            sb.append(" ").append(String.valueOf(o));
        }
        return sb.toString();
    }
}

