/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.instance.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.HttpStatus;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/instance/promoteInstance/0.1.0")
public class PromoteInstance
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(PromoteInstance.class);

    protected String getCloudEventType() {
        return "InstancePromotedEvent";
    }

    protected String getCloudEventAggregateType() {
        return "Instance";
    }

    protected String getCloudEventAggregateId(Map<String, Object> map) {
        return (String)map.get("instanceId");
    }

    protected Result<Map<String, Object>> validateInput(HttpServerExchange exchange, Map<String, Object> map, String userId, String host) {
        Set applicableResourceTypes = Set.of();
        Set applicableConfigTypes = Set.of();
        Set applicablePropertyTypes = Set.of();
        Result applicablePropertiesResult = HybridQueryClient.getApplicableConfigPropertiesForInstance((HttpServerExchange)exchange, (String)((String)map.get("hostId")), (String)((String)map.get("instanceId")), applicableResourceTypes, applicableConfigTypes, applicablePropertyTypes, (int)0, (int)Integer.MAX_VALUE);
        if (applicablePropertiesResult.isFailure()) {
            return Failure.of((Status)applicablePropertiesResult.getError());
        }
        return PromoteInstanceInputValidator.validate(map, (String)applicablePropertiesResult.getResult());
    }

    protected Logger getLogger() {
        return logger;
    }

    static final class PromoteInstanceInputValidator {
        private static final String PROPERTIES_NOT_FOUND_ERROR_CODE = "ERR11210";
        private static final String PROPERTIES_NOT_FOUND_ERROR_MESSAGE = "APPLICABLE_PROPERTIES_NOT_FOUND";
        private static final String PROPERTIES_NOT_FOUND_ERROR_DESCRIPTION = "The system is not able to find any applicable properties. Please ensure that the system is correctly configured and has applicable properties defined.";
        private static final String INVALID_PROMOTABLE_CONFIGS_ERROR_CODE = "ERR11310";
        private static final String INVALID_PROMOTABLE_CONFIGS_ERROR_DESCRIPTION = "The promotable instance that has been provided is not valid";
        private static final String INSTANCE_APPLICABLE_PROPERTIES_KEY = "instanceApplicableProperties";
        private static final String CONFIG_ID_KEY = "configId";
        private static final String CONFIG_NAME_KEY = "configName";
        private static final String PROPERTY_ID_KEY = "propertyId";
        private static final String PROPERTY_NAME_KEY = "propertyName";
        private static final String PROPERTY_VALUE_TYPE_KEY = "valueType";
        private static final String PROPERTY_RESOURCE_TYPE_KEY = "resourceType";
        private static final String PROMOTABLE_RESOURCE_CONFIGS_KEY = "configs";
        private static final String PROMOTABLE_APIS_KEY = "apis";
        private static final String PROMOTABLE_APPS_KEY = "apps";
        private static final String RESOURCE_UID_KEY = "uid";
        private static final String RESOURCE_PATH_PREFIXES_KEY = "path_prefixes";
        private static final String INSTANCE_CONFIG_ERRORS_RESULT_KEY = "instanceConfigErrors";
        private static final String API_ERROR_RESULT_KEY = "apiErrors";
        private static final String APP_ERRORS_RESULT_KEY = "appErrors";
        private static final String INSTANCE_CONFIG_PROPERTY_VALUE_ERROR_FORMAT = "Property value for Property Name %s is not valid for value type %s";
        private static final String INSTANCE_PROPERTY_NAME_NOT_FOUND_ERROR_FORMAT = "Property name %s not found";
        private static final String INVALID_API_UID_ERROR_FORMAT = "%s Invalid api uid";
        private static final String EMPTY_PATH_PREFIXES_ERROR_FORMAT = "%s empty api path prefixes provided";
        private static final String INVALID_APP_UID_ERROR_FORMAT = "%s Invalid app uid";
        private static final String EMPTY_INSTANCE_API_CONFIGS_ERROR_FORMAT = "%s api configs are empty";
        private static final String EMPTY_INSTANCE_APP_CONFIGS_ERROR_FORMAT = "%s app configs are empty";
        private static final String RESOURCE_PROPERTY_VALUE_ERROR_FORMAT = "%s Property value for Property Name %s is not valid for value type %s";
        private static final String INVALID_INSTANCE_API_RESOURCE_ERROR_FORMAT = "%s Property for Property Name %s is not valid for instance api";
        private static final String INVALID_PROPERTY_NAME_FOR_RESOURCE_ERROR_FORMAT = "%s Property name %s not found";
        private static final String INVALID_INSTANCE_APP_RESOURCE_ERROR_FORMAT = "%s Property for Property Name %s is not valid for instance app";
        private static final String INVALID_INSTANCE_APP_API_RESOURCE_ERROR_FORMAT = "%s Property for Property Name %s is not valid for instance app-api";
        private static final Set<String> INSTANCE_API_RESOURCE_TYPES = Set.of("api", "api|app_api", "all");
        private static final Set<String> INSTANCE_APP_RESOURCE_TYPES = Set.of("app", "app|app_api", "all");
        private static final Set<String> INSTANCE_APP_API_RESOURCE_TYPES = Set.of("app_api", "api|app_api", "app|app_api", "all");

        private PromoteInstanceInputValidator() {
        }

        public static Result<Map<String, Object>> validate(Map<String, Object> toValidate, String instanceApplicablePropertiesJson) {
            List appErrors;
            List toValidateApps;
            List apiErrors;
            List toValidateApis;
            List instanceConfigErrors;
            Map rawResultAsMap = JsonMapper.string2Map((String)instanceApplicablePropertiesJson);
            if (Objects.isNull(rawResultAsMap) || !rawResultAsMap.containsKey(INSTANCE_APPLICABLE_PROPERTIES_KEY)) {
                return Failure.of((Status)PromoteInstanceInputValidator.propertiesNotFound());
            }
            List rawApplicableProperties = (List)rawResultAsMap.get(INSTANCE_APPLICABLE_PROPERTIES_KEY);
            List<InstanceProperty> sourceProperties = rawApplicableProperties.stream().map(map -> new InstanceProperty((String)map.get(CONFIG_ID_KEY), (String)map.get(PROPERTY_ID_KEY), Objects.nonNull(map.get(CONFIG_NAME_KEY)) ? ((String)map.get(CONFIG_NAME_KEY)).trim() : "", Objects.nonNull(map.get(PROPERTY_NAME_KEY)) ? ((String)map.get(PROPERTY_NAME_KEY)).trim() : "", (String)map.get(PROPERTY_VALUE_TYPE_KEY), (String)map.get(PROPERTY_RESOURCE_TYPE_KEY))).toList();
            Map sourcePropertiesByName = sourceProperties.stream().filter(InstanceProperty::isValid).collect(Collectors.toMap(InstanceProperty::fullyQualifiedPropertyName, Function.identity(), (existing, replacement) -> existing));
            Map toValidateInstanceConfigs = (Map)toValidate.get(PROMOTABLE_RESOURCE_CONFIGS_KEY);
            HashMap<String, Object> errorsMap = new HashMap<String, Object>();
            if (Objects.nonNull(toValidateInstanceConfigs) && !toValidateInstanceConfigs.isEmpty() && !(instanceConfigErrors = toValidateInstanceConfigs.entrySet().stream().map(entry -> PromoteInstanceInputValidator.validateInstanceConfig(entry, sourcePropertiesByName)).filter(errors -> !errors.isEmpty()).flatMap(Collection::stream).toList()).isEmpty()) {
                errorsMap.put(INSTANCE_CONFIG_ERRORS_RESULT_KEY, instanceConfigErrors);
            }
            if (Objects.nonNull(toValidateApis = (List)toValidate.get(PROMOTABLE_APIS_KEY)) && !toValidateApis.isEmpty() && !(apiErrors = toValidateApis.stream().map(api -> PromoteInstanceInputValidator.validateInstanceApi(api, sourcePropertiesByName)).filter(e -> !e.isEmpty()).flatMap(Collection::stream).toList()).isEmpty()) {
                errorsMap.put(API_ERROR_RESULT_KEY, apiErrors);
            }
            if (Objects.nonNull(toValidateApps = (List)toValidate.get(PROMOTABLE_APPS_KEY)) && !toValidateApps.isEmpty() && !(appErrors = toValidateApps.stream().map(app -> PromoteInstanceInputValidator.validateInstanceApp(app, sourcePropertiesByName)).filter(e -> !e.isEmpty()).flatMap(Collection::stream).toList()).isEmpty()) {
                errorsMap.put(APP_ERRORS_RESULT_KEY, appErrors);
            }
            return errorsMap.isEmpty() ? Success.of(toValidate) : Failure.of((Status)PromoteInstanceInputValidator.invalidPromotableInstance(errorsMap));
        }

        private static Set<String> validateInstanceConfig(Map.Entry<String, Object> entry, Map<String, InstanceProperty> sourcePropertiesByName) {
            HashSet<String> errors = new HashSet<String>();
            String key = entry.getKey();
            if (sourcePropertiesByName.containsKey(key)) {
                String valueType;
                Object value = entry.getValue();
                boolean isValid = PromoteInstanceInputValidator.isValueValid(value, valueType = sourcePropertiesByName.get(key).valueType());
                if (!isValid) {
                    errors.add(String.format(INSTANCE_CONFIG_PROPERTY_VALUE_ERROR_FORMAT, key, valueType));
                }
            } else {
                errors.add(String.format(INSTANCE_PROPERTY_NAME_NOT_FOUND_ERROR_FORMAT, key));
            }
            return errors;
        }

        private static Set<String> validateInstanceApi(Map<String, Object> api, Map<String, InstanceProperty> sourcePropertiesByName) {
            String apiPrefix;
            HashSet<String> errors = new HashSet<String>();
            String uid = (String)api.get(RESOURCE_UID_KEY);
            if (Objects.isNull(uid) || uid.isBlank() || uid.replace("-", "").isBlank()) {
                apiPrefix = "<<api(na)>>";
                errors.add(String.format(INVALID_API_UID_ERROR_FORMAT, apiPrefix));
            } else {
                apiPrefix = String.format("<<api(%s)>>", uid.trim());
            }
            List pathPrefixes = (List)api.get(RESOURCE_PATH_PREFIXES_KEY);
            if (Objects.isNull(pathPrefixes) || pathPrefixes.isEmpty()) {
                errors.add(String.format(EMPTY_PATH_PREFIXES_ERROR_FORMAT, apiPrefix));
            }
            Map configs = (Map)api.get(PROMOTABLE_RESOURCE_CONFIGS_KEY);
            errors.addAll(PromoteInstanceInputValidator.validateInstanceApiConfigs(configs, sourcePropertiesByName, apiPrefix));
            List apps = (List)api.get(PROMOTABLE_APPS_KEY);
            if (Objects.nonNull(apps) && !apps.isEmpty()) {
                List apiAppsErrors = apps.stream().map(app -> PromoteInstanceInputValidator.validateInstanceApiApp(app, sourcePropertiesByName, apiPrefix)).filter(e -> !e.isEmpty()).flatMap(Collection::stream).toList();
                errors.addAll(apiAppsErrors);
            }
            return errors;
        }

        private static Set<String> validateInstanceApp(Map<String, Object> app, Map<String, InstanceProperty> sourcePropertiesByName) {
            String appPrefix;
            HashSet<String> errors = new HashSet<String>();
            String uid = (String)app.get(RESOURCE_UID_KEY);
            if (Objects.isNull(uid) || uid.isBlank()) {
                appPrefix = "<<app(na)>>";
                errors.add(String.format(INVALID_APP_UID_ERROR_FORMAT, appPrefix));
            } else {
                appPrefix = String.format("<<app(%s)>>", uid.trim());
            }
            Map configs = (Map)app.get(PROMOTABLE_RESOURCE_CONFIGS_KEY);
            errors.addAll(PromoteInstanceInputValidator.validateInstanceAppConfigs(configs, sourcePropertiesByName, appPrefix));
            return errors;
        }

        private static Set<String> validateInstanceApiApp(Map<String, Object> app, Map<String, InstanceProperty> sourcePropertiesByName, String apiPrefix) {
            Object apiAppPrefix;
            HashSet<String> errors = new HashSet<String>();
            String uid = (String)app.get(RESOURCE_UID_KEY);
            if (Objects.isNull(uid) || uid.isBlank()) {
                apiAppPrefix = apiPrefix + "<<app(na)>>";
                errors.add(String.format(INVALID_APP_UID_ERROR_FORMAT, apiAppPrefix));
            } else {
                apiAppPrefix = String.format("%s<<app(%s)>>", apiPrefix, uid.trim());
            }
            Map configs = (Map)app.get(PROMOTABLE_RESOURCE_CONFIGS_KEY);
            errors.addAll(PromoteInstanceInputValidator.validateInstanceAppApiConfigs(configs, sourcePropertiesByName, (String)apiAppPrefix));
            return errors;
        }

        private static Set<String> validateInstanceApiConfigs(Map<String, Object> configs, Map<String, InstanceProperty> sourcePropertiesByName, String apiPrefix) {
            HashSet<String> errors = new HashSet<String>();
            if (Objects.isNull(configs) || configs.isEmpty()) {
                errors.add(String.format(EMPTY_INSTANCE_API_CONFIGS_ERROR_FORMAT, apiPrefix));
            } else {
                List configErrors = configs.entrySet().stream().map(config -> PromoteInstanceInputValidator.validateInstanceApiConfig(config, sourcePropertiesByName, apiPrefix)).filter(e -> !e.isEmpty()).flatMap(Collection::stream).toList();
                errors.addAll(configErrors);
            }
            return errors;
        }

        private static Set<String> validateInstanceAppConfigs(Map<String, Object> configs, Map<String, InstanceProperty> sourcePropertiesByName, String appPrefix) {
            HashSet<String> errors = new HashSet<String>();
            if (Objects.isNull(configs) || configs.isEmpty()) {
                errors.add(String.format(EMPTY_INSTANCE_APP_CONFIGS_ERROR_FORMAT, appPrefix));
            } else {
                List configErrors = configs.entrySet().stream().map(config -> PromoteInstanceInputValidator.validateInstanceAppConfig(config, sourcePropertiesByName, appPrefix)).filter(e -> !e.isEmpty()).flatMap(Collection::stream).toList();
                errors.addAll(configErrors);
            }
            return errors;
        }

        private static Set<String> validateInstanceAppApiConfigs(Map<String, Object> configs, Map<String, InstanceProperty> sourcePropertiesByName, String apiAppPrefix) {
            HashSet<String> errors = new HashSet<String>();
            if (Objects.isNull(configs) || configs.isEmpty()) {
                errors.add(String.format(EMPTY_INSTANCE_APP_CONFIGS_ERROR_FORMAT, apiAppPrefix));
            } else {
                List configErrors = configs.entrySet().stream().map(config -> PromoteInstanceInputValidator.validateInstanceApiAppConfig(config, sourcePropertiesByName, apiAppPrefix)).filter(e -> !e.isEmpty()).flatMap(Collection::stream).toList();
                errors.addAll(configErrors);
            }
            return errors;
        }

        private static Set<String> validateInstanceApiConfig(Map.Entry<String, Object> entry, Map<String, InstanceProperty> sourcePropertiesByName, String apiPrefix) {
            HashSet<String> errors = new HashSet<String>();
            String key = entry.getKey();
            if (sourcePropertiesByName.containsKey(key)) {
                String resourceType;
                String valueType;
                Object value = entry.getValue();
                boolean isValid = PromoteInstanceInputValidator.isValueValid(value, valueType = sourcePropertiesByName.get(key).valueType());
                if (!isValid) {
                    errors.add(String.format(RESOURCE_PROPERTY_VALUE_ERROR_FORMAT, apiPrefix, key, valueType));
                }
                if (Objects.isNull(resourceType = sourcePropertiesByName.get(key).resourceType()) || resourceType.isBlank() || !INSTANCE_API_RESOURCE_TYPES.contains(resourceType.toLowerCase())) {
                    errors.add(String.format(INVALID_INSTANCE_API_RESOURCE_ERROR_FORMAT, apiPrefix, key));
                }
            } else {
                errors.add(String.format(INVALID_PROPERTY_NAME_FOR_RESOURCE_ERROR_FORMAT, apiPrefix, key));
            }
            return errors;
        }

        private static Set<String> validateInstanceAppConfig(Map.Entry<String, Object> entry, Map<String, InstanceProperty> sourcePropertiesByName, String appPrefix) {
            HashSet<String> errors = new HashSet<String>();
            String key = entry.getKey();
            if (sourcePropertiesByName.containsKey(key)) {
                String resourceType;
                String valueType;
                Object value = entry.getValue();
                boolean isValid = PromoteInstanceInputValidator.isValueValid(value, valueType = sourcePropertiesByName.get(key).valueType());
                if (!isValid) {
                    errors.add(String.format(RESOURCE_PROPERTY_VALUE_ERROR_FORMAT, appPrefix, key, valueType));
                }
                if (Objects.isNull(resourceType = sourcePropertiesByName.get(key).resourceType()) || resourceType.isBlank() || !INSTANCE_APP_RESOURCE_TYPES.contains(resourceType.toLowerCase())) {
                    errors.add(String.format(INVALID_INSTANCE_APP_RESOURCE_ERROR_FORMAT, appPrefix, key));
                }
            } else {
                errors.add(String.format(INVALID_PROPERTY_NAME_FOR_RESOURCE_ERROR_FORMAT, appPrefix, key));
            }
            return errors;
        }

        private static Set<String> validateInstanceApiAppConfig(Map.Entry<String, Object> entry, Map<String, InstanceProperty> sourcePropertiesByName, String apiAppPrefix) {
            HashSet<String> errors = new HashSet<String>();
            String key = entry.getKey();
            if (sourcePropertiesByName.containsKey(key)) {
                String resourceType;
                String valueType;
                Object value = entry.getValue();
                boolean isValid = PromoteInstanceInputValidator.isValueValid(value, valueType = sourcePropertiesByName.get(key).valueType());
                if (!isValid) {
                    errors.add(String.format(RESOURCE_PROPERTY_VALUE_ERROR_FORMAT, apiAppPrefix, key, valueType));
                }
                if (Objects.isNull(resourceType = sourcePropertiesByName.get(key).resourceType()) || resourceType.isBlank() || !INSTANCE_APP_API_RESOURCE_TYPES.contains(resourceType.toLowerCase())) {
                    errors.add(String.format(INVALID_INSTANCE_APP_API_RESOURCE_ERROR_FORMAT, apiAppPrefix, key));
                }
            } else {
                errors.add(String.format(INVALID_PROPERTY_NAME_FOR_RESOURCE_ERROR_FORMAT, apiAppPrefix, key));
            }
            return errors;
        }

        private static boolean isValueValid(Object value, String valueType) {
            if (Objects.isNull(value)) {
                return true;
            }
            return switch (valueType.toLowerCase()) {
                case "boolean" -> value instanceof Boolean;
                case "integer" -> {
                    if (value instanceof Short || value instanceof Integer || value instanceof Long) {
                        yield true;
                    }
                    yield false;
                }
                case "float" -> {
                    if (value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                        yield true;
                    }
                    yield false;
                }
                case "map" -> value instanceof Map;
                case "list" -> value instanceof Collection;
                case "string" -> value instanceof CharSequence;
                default -> false;
            };
        }

        private static Status propertiesNotFound() {
            return new Status(HttpStatus.BAD_REQUEST.value(), PROPERTIES_NOT_FOUND_ERROR_CODE, PROPERTIES_NOT_FOUND_ERROR_MESSAGE, PROPERTIES_NOT_FOUND_ERROR_DESCRIPTION);
        }

        private static Status invalidPromotableInstance(Map<String, Object> errorsMap) {
            return new Status(HttpStatus.BAD_REQUEST.value(), INVALID_PROMOTABLE_CONFIGS_ERROR_CODE, JsonMapper.toJson(errorsMap), INVALID_PROMOTABLE_CONFIGS_ERROR_DESCRIPTION);
        }

        private record InstanceProperty(String configId, String propertyId, String configName, String propertyName, String valueType, String resourceType) {
            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                InstanceProperty that = (InstanceProperty)o;
                return Objects.equals(this.configId, that.configId) && Objects.equals(this.propertyId, that.propertyId);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.configId, this.propertyId);
            }

            public boolean isValid() {
                return Objects.nonNull(this.configId) && !this.configId.isBlank() && Objects.nonNull(this.propertyId) && !this.propertyId.isBlank() && Objects.nonNull(this.configName) && !this.configName.isBlank() && Objects.nonNull(this.propertyName) && !this.propertyName.isBlank() && Objects.nonNull(this.valueType) && !this.valueType.isBlank();
            }

            public String fullyQualifiedPropertyName() {
                if (Objects.nonNull(this.configName) && !this.configName.isBlank() && Objects.nonNull(this.propertyName) && !this.propertyName.isBlank()) {
                    return this.configName.concat(".").concat(this.propertyName);
                }
                return "";
            }
        }
    }
}

