/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import xapi.bytecode.CannotCompileException;
import xapi.bytecode.ClassFile;
import xapi.bytecode.ClassPool;
import xapi.bytecode.CtClass;
import xapi.bytecode.CtClassType;
import xapi.bytecode.CtConstructor;
import xapi.source.X_Modifier;

class CtNewClass
extends CtClassType {
    protected boolean hasConstructor;

    CtNewClass(String name, ClassPool cp, boolean isInterface, CtClass superclass) {
        super(name, cp);
        this.wasChanged = true;
        String superName = isInterface || superclass == null ? null : superclass.getName();
        this.classfile = new ClassFile(isInterface, name, superName);
        if (isInterface && superclass != null) {
            this.classfile.setInterfaces(new String[]{superclass.getName()});
        }
        this.setModifiers(X_Modifier.setPublic((int)this.getModifiers()));
        this.hasConstructor = isInterface;
    }

    @Override
    protected void extendToString(StringBuffer buffer) {
        if (this.hasConstructor) {
            buffer.append("hasConstructor ");
        }
        super.extendToString(buffer);
    }

    @Override
    public void addConstructor(CtConstructor c) throws CannotCompileException {
        this.hasConstructor = true;
        super.addConstructor(c);
    }

    private boolean isInheritable(int mod, CtClass superclazz) {
        if (X_Modifier.isPrivate((int)mod)) {
            return false;
        }
        if (X_Modifier.isPackage((int)mod)) {
            String pname = this.getPackageName();
            String pname2 = superclazz.getPackageName();
            if (pname == null) {
                return pname2 == null;
            }
            return pname.equals(pname2);
        }
        return true;
    }
}

