/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.attributes;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import xapi.bytecode.ConstPool;
import xapi.bytecode.attributes.AttributeInfo;
import xapi.util.X_Byte;

public class ConstantAttribute
extends AttributeInfo {
    public static final String tag = "ConstantValue";

    ConstantAttribute(ConstPool cp, int n, DataInput in) throws IOException {
        super(cp, n, in);
    }

    public ConstantAttribute(ConstPool cp, int index) {
        super(cp, tag);
        byte[] bvalue = new byte[]{(byte)(index >>> 8), (byte)index};
        this.set(bvalue);
    }

    public int getConstantValue() {
        return X_Byte.readU16bit((byte[])this.get(), (int)0);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<?, ?> classnames) {
        int index = this.getConstPool().copy(this.getConstantValue(), newCp, classnames);
        return new ConstantAttribute(newCp, index);
    }
}

