/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.impl;

import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import xapi.bytecode.ClassPool;
import xapi.bytecode.CtClass;
import xapi.bytecode.CtClassType;
import xapi.bytecode.CtField;
import xapi.bytecode.CtMethod;
import xapi.bytecode.NotFoundException;
import xapi.bytecode.annotation.Annotation;
import xapi.bytecode.annotation.AnnotationDefaultAttribute;
import xapi.bytecode.annotation.MemberValue;
import xapi.bytecode.attributes.ExceptionsAttribute;
import xapi.bytecode.attributes.SignatureAttribute;
import xapi.bytecode.impl.BytecodeUtil;
import xapi.collect.api.InitMap;
import xapi.collect.impl.InitMapDefault;
import xapi.except.NotImplemented;
import xapi.except.NotYetImplemented;
import xapi.inject.impl.SingletonProvider;
import xapi.log.X_Log;
import xapi.source.X_Modifier;
import xapi.source.X_Source;
import xapi.source.api.IsAnnotation;
import xapi.source.api.IsAnnotationValue;
import xapi.source.api.IsClass;
import xapi.source.api.IsField;
import xapi.source.api.IsGeneric;
import xapi.source.api.IsMember;
import xapi.source.api.IsMethod;
import xapi.source.api.IsType;
import xapi.source.api.Primitives;
import xapi.source.impl.DeclaredMemberFilter;
import xapi.source.impl.ImmutableType;
import xapi.source.impl.IsClassDelegate;
import xapi.source.service.SourceAdapterService;
import xapi.util.X_Debug;
import xapi.util.X_String;
import xapi.util.api.ConvertsValue;
import xapi.util.api.Pair;

public class BytecodeAdapterService
implements SourceAdapterService<String, CtMethod, CtField, Annotation> {
    private final ClassPool pool;
    protected final SingletonProvider<ClassPool> classPool = new SingletonProvider<ClassPool>(){

        protected ClassPool initialValue() {
            for (URL url : BytecodeAdapterService.this.getScanUrls()) {
                try {
                    BytecodeAdapterService.this.pool.appendClassPath(url.toExternalForm().replace("file:", ""));
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
            return BytecodeAdapterService.this.pool;
        }
    };
    InitMap<String, IsClass> classes = new InitMapDefault(InitMapDefault.PASS_THRU, (ConvertsValue)new ConvertsValue<String, IsClass>(){

        public IsClass convert(String classString) {
            Object asClass;
            Pair cls = X_Source.extractArrayDepth((String)classString);
            URL location = X_Source.classToUrl((String)((String)cls.get0()), (ClassLoader)BytecodeAdapterService.this.getClassLoader());
            try {
                X_Log.debug((Object[])new Object[]{"Converting", cls.get0(), "to", location});
                asClass = new ClassAdapter(new CtClassType(location.openStream(), (ClassPool)BytecodeAdapterService.this.classPool.get()));
            }
            catch (NullPointerException e) {
                if (((String)cls.get0()).equals(((String)cls.get0()).toLowerCase())) {
                    asClass = Primitives.valueOf((String)("_" + (String)cls.get0()));
                }
                throw X_Debug.rethrow((Throwable)e);
            }
            catch (IOException e) {
                X_Log.error((Object[])new Object[]{"Unable to find " + (String)cls.get0()});
                throw X_Debug.rethrow((Throwable)e);
            }
            if ((Integer)cls.get1() > 0) {
                return new IsClassDelegate((IsClass)asClass, ((Integer)cls.get1()).intValue());
            }
            return asClass;
        }
    });
    private final ConvertsValue<Annotation, IsAnnotation> annotationBuilder = new ConvertsValue<Annotation, IsAnnotation>(){

        public IsAnnotation convert(Annotation from) {
            return new AnnotationAdapter(from);
        }
    };
    private final ConvertsValue<CtMethod, IsMethod> methodBuilder = new ConvertsValue<CtMethod, IsMethod>(){

        public IsMethod convert(CtMethod from) {
            return new MethodAdapter(from);
        }
    };
    private final ConvertsValue<CtField, IsField> fieldBuilder = new ConvertsValue<CtField, IsField>(){

        public IsField convert(CtField from) {
            return new FieldAdapter(from);
        }
    };
    private final ConvertsValue<CtClass, IsClass> interfaceBuilder = new ConvertsValue<CtClass, IsClass>(){

        public IsClass convert(CtClass from) {
            return BytecodeAdapterService.this.toClass(from.getName());
        }
    };

    public BytecodeAdapterService() {
        this(new ClassPool(true));
    }

    public BytecodeAdapterService(ClassPool pool) {
        this.pool = pool;
    }

    protected URL[] getScanUrls() {
        return X_Source.getUrls((ClassLoader)this.getClassLoader());
    }

    public IsClass toClass(String binaryName) {
        return (IsClass)this.classes.get((Object)binaryName);
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public IsMethod toMethod(CtMethod type) {
        return new MethodAdapter(type);
    }

    public IsField toField(CtField type) {
        return new FieldAdapter(type);
    }

    public IsAnnotation toAnnotation(Annotation type) {
        return new AnnotationAdapter(type);
    }

    public IsType[] toTypes(CtClass[] parameterTypes) {
        IsType[] types = new IsType[parameterTypes.length];
        for (CtClass param : parameterTypes) {
            types[i] = X_Source.toType((String)param.getPackageName(), (String)param.getEnclosedName());
        }
        return types;
    }

    class FieldAdapter
    extends MemberAdapter
    implements IsField {
        private CtField field;

        public FieldAdapter(CtField type) {
            super(type.getModifiers(), type.getDeclaringClass().getPackageName(), type.getDeclaringClass().getEnclosedName());
            this.field = type;
        }

        @Override
        protected Annotation[] getRawAnnotations() {
            return this.field.getFieldInfo2().getAnnotations();
        }

        public IsClass getEnclosingType() {
            return (IsClass)super.getEnclosingType();
        }

        public String getDeclaredName() {
            return this.field.getName();
        }

        public boolean isStatic() {
            return X_Modifier.isStatic((int)this.getModifier());
        }

        public boolean isVolatile() {
            return X_Modifier.isVolatile((int)this.getModifier());
        }

        public boolean isTransient() {
            return X_Modifier.isTransient((int)this.getModifier());
        }

        public String toSignature() {
            return this.field.getSignature();
        }

        @Override
        public String toString() {
            return this.toSignature();
        }
    }

    class MethodAdapter
    extends MemberAdapter
    implements IsMethod {
        private CtMethod method;

        public MethodAdapter(CtMethod type) {
            super(type.getModifiers(), type.getDeclaringClass().getPackageName(), type.getDeclaringClass().getEnclosedName());
            this.method = type;
        }

        @Override
        protected Annotation[] getRawAnnotations() {
            return this.method.getMethodInfo2().getAnnotations();
        }

        public IsClass getEnclosingType() {
            return BytecodeAdapterService.this.toClass(this.type.getPackage() + "." + this.type.getEnclosedName().replace('.', '$'));
        }

        public boolean isAbstract() {
            return X_Modifier.isAbstract((int)this.getModifier());
        }

        @Override
        public IsAnnotation getAnnotation(String name) {
            return super.getAnnotation(name);
        }

        public boolean isStatic() {
            return X_Modifier.isStatic((int)this.getModifier());
        }

        public String getName() {
            return this.method.getName();
        }

        public IsType getReturnType() {
            try {
                CtClass returnType = this.method.getReturnType();
                return X_Source.toType((String)returnType.getPackageName(), (String)returnType.getEnclosedName());
            }
            catch (NotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public IsType[] getParameters() {
            try {
                return BytecodeAdapterService.this.toTypes(this.method.getParameterTypes());
            }
            catch (NotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public IsGeneric[] getGenerics() {
            return null;
        }

        public IsType[] getExceptions() {
            try {
                return BytecodeAdapterService.this.toTypes(this.method.getExceptionTypes());
            }
            catch (NotFoundException e) {
                ExceptionsAttribute exceptions = this.method.getMethodInfo2().getExceptionsAttribute();
                return X_Source.toTypes((String[])exceptions.getExceptions());
            }
        }

        public IsAnnotationValue getDefaultValue() {
            ImmutableType type;
            AnnotationDefaultAttribute def = (AnnotationDefaultAttribute)this.method.getMethodInfo2().getAttribute("AnnotationDefault");
            try {
                type = new ImmutableType(this.method.getReturnType().getPackageName(), this.method.getReturnType().getEnclosedName());
            }
            catch (NotFoundException e) {
                X_Log.warn((Object[])new Object[]{"Not able to lookup return type for ", this.method, e});
                type = null;
            }
            return def == null ? null : BytecodeUtil.extractValue(def.getDefaultValue(), BytecodeAdapterService.this, (IsType)type);
        }

        public String toSignature() {
            return this.method.getSignature();
        }

        @Override
        public String toString() {
            try {
                return this.method.getReturnType().getName() + " " + this.method.getLongName();
            }
            catch (NotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    class ClassAdapter
    extends MemberAdapter
    implements IsClass {
        private CtClass cls;
        private SingletonProvider<Iterable<IsMethod>> methods;
        private SingletonProvider<Iterable<IsField>> fields;
        private SingletonProvider<Iterable<IsClass>> interfaces;
        private SingletonProvider<Iterable<IsClass>> innerClasses;

        public ClassAdapter(CtClass type) {
            super(type.getModifiers(), type.getPackageName(), type.getEnclosedName());
            this.methods = new SingletonProvider<Iterable<IsMethod>>(){

                protected Iterable<IsMethod> initialValue() {
                    return new MemberIterable(BytecodeAdapterService.this.methodBuilder, ClassAdapter.this.cls.getMethods());
                }
            };
            this.fields = new SingletonProvider<Iterable<IsField>>(){

                protected Iterable<IsField> initialValue() {
                    return new MemberIterable(BytecodeAdapterService.this.fieldBuilder, ClassAdapter.this.cls.getFields());
                }
            };
            this.interfaces = new SingletonProvider<Iterable<IsClass>>(){

                protected Iterable<IsClass> initialValue() {
                    try {
                        return new MemberIterable(BytecodeAdapterService.this.interfaceBuilder, ClassAdapter.this.cls.getInterfaces());
                    }
                    catch (NotFoundException e) {
                        throw new RuntimeException("Unable to load interfaces for " + X_String.join((String)", ", (String[])ClassAdapter.this.cls.getClassFile2().getInterfaces()), e);
                    }
                }
            };
            this.innerClasses = new SingletonProvider<Iterable<IsClass>>(){

                protected Iterable<IsClass> initialValue() {
                    try {
                        return new MemberIterable(BytecodeAdapterService.this.interfaceBuilder, ClassAdapter.this.cls.getNestedClasses());
                    }
                    catch (NotFoundException e) {
                        throw new RuntimeException("Unable to load interfaces for " + ClassAdapter.this.cls.getAttribute("InnerClasses"), e);
                    }
                }
            };
            this.cls = type;
        }

        @Override
        protected Annotation[] getRawAnnotations() {
            return this.cls.getClassFile2().getAnnotations();
        }

        public Iterable<IsMethod> getDeclaredMethods() {
            return new DeclaredMemberFilter(this.getMethods(), (IsType)this);
        }

        public Iterable<IsMethod> getMethods() {
            return (Iterable)this.methods.get();
        }

        public IsMethod getMethod(String name, IsType ... params) {
            assert (name != null);
            for (IsMethod method : this.getMethods()) {
                if (!method.getName().equals(name) || !X_Source.typesEqual((IsType[])method.getParameters(), (IsType[])params)) continue;
                return method;
            }
            return null;
        }

        @Override
        public IsAnnotation getAnnotation(String name) {
            return super.getAnnotation(name);
        }

        public IsMethod getMethod(String name, boolean checkErased, Class<?> ... params) {
            assert (name != null);
            for (IsMethod method : this.getMethods()) {
                if (!method.getName().equals(name) || !X_Source.typesEqual((IsType[])method.getParameters(), (Class[])params)) continue;
                return method;
            }
            if (checkErased) {
                // empty if block
            }
            return null;
        }

        public Iterable<IsField> getFields() {
            return (Iterable)this.fields.get();
        }

        public IsField getField(String name) {
            for (IsField field : this.getFields()) {
                if (!field.getDeclaredName().equals(name)) continue;
                return field;
            }
            return null;
        }

        public Iterable<IsGeneric> getGenerics() {
            SignatureAttribute attr = (SignatureAttribute)this.cls.getClassFile2().getAttribute("Signature");
            if (attr == null) {
                return Collections.EMPTY_LIST;
            }
            System.err.println(attr);
            return Collections.EMPTY_LIST;
        }

        public IsGeneric getGeneric(String name) {
            for (IsGeneric g : this.getGenerics()) {
                if (!g.genericName().equals(name)) continue;
                return g;
            }
            return null;
        }

        public boolean hasGenerics() {
            return this.getGenerics().iterator().hasNext();
        }

        public Iterable<IsClass> getInterfaces() {
            return (Iterable)this.interfaces.get();
        }

        public boolean hasInterface() {
            try {
                return this.cls.getInterfaces().length > 0;
            }
            catch (NotFoundException e) {
                throw X_Debug.rethrow((Throwable)e);
            }
        }

        public boolean isAbstract() {
            return X_Modifier.isAbstract((int)this.getModifier());
        }

        public boolean isAnnotation() {
            return X_Modifier.isAnnotation((int)this.getModifier());
        }

        public boolean isArray() {
            return this.cls.isArray();
        }

        public boolean isEnum() {
            return X_Modifier.isEnum((int)this.getModifier());
        }

        public boolean isFinal() {
            return X_Modifier.isFinal((int)this.getModifier());
        }

        public boolean isStatic() {
            return X_Modifier.isStatic((int)this.getModifier());
        }

        public boolean isInterface() {
            return this.cls.isInterface();
        }

        public IsMethod getEnclosingMethod() {
            try {
                CtMethod enclosed = this.cls.getEnclosingMethod();
                if (enclosed == null) {
                    return null;
                }
                IsClass method = BytecodeAdapterService.this.toClass(enclosed.getDeclaringClass().getName());
                return method.getMethod(enclosed.getName(), BytecodeAdapterService.this.toTypes(enclosed.getParameterTypes()));
            }
            catch (NotFoundException e) {
                throw X_Debug.rethrow((Throwable)e);
            }
        }

        public Iterable<IsClass> getInnerClasses() {
            CtClass[] clses;
            try {
                clses = this.cls.getNestedClasses();
            }
            catch (NotFoundException e) {
                throw X_Debug.rethrow((Throwable)e);
            }
            ArrayList<IsClass> asClasses = new ArrayList<IsClass>(clses.length);
            for (CtClass cls : clses) {
                asClasses.add(new ClassAdapter(cls));
            }
            return asClasses;
        }

        public Class<?> toClass(ClassLoader loader) throws ClassNotFoundException {
            throw new NotImplemented("Class loading is not yet implemented");
        }

        public String toSignature() {
            return this.cls.getName();
        }

        @Override
        public final String toString() {
            return this.cls.getName();
        }
    }

    class MemberIterable<From, To>
    implements Iterable<To> {
        private To[] members;

        public MemberIterable(ConvertsValue<From, To> converter, From[] from) {
            this.members = new Object[from.length];
            int m = from.length;
            for (int i = 0; i < m; ++i) {
                this.members[i] = converter.convert(from[i]);
            }
        }

        @Override
        public Iterator<To> iterator() {
            return new Itr();
        }

        private class Itr
        implements Iterator<To> {
            private int pos = 0;

            private Itr() {
            }

            @Override
            public boolean hasNext() {
                return this.pos < MemberIterable.this.members.length;
            }

            @Override
            public To next() {
                return MemberIterable.this.members[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    abstract class MemberAdapter
    implements IsMember {
        int modifier;
        ImmutableType type;
        protected final SingletonProvider<Iterable<IsAnnotation>> annotations = new SingletonProvider<Iterable<IsAnnotation>>(){

            protected Iterable<IsAnnotation> initialValue() {
                Annotation[] annos = MemberAdapter.this.getRawAnnotations();
                if (annos == null) {
                    annos = new Annotation[]{};
                }
                return new MemberIterable(BytecodeAdapterService.this.annotationBuilder, annos);
            }
        };

        MemberAdapter(int modifier, String pkg, String enclosedName) {
            this.modifier = modifier;
            this.type = new ImmutableType(pkg, enclosedName);
        }

        protected abstract Annotation[] getRawAnnotations();

        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        public IsType getEnclosingType() {
            return this.type.getEnclosingType();
        }

        public String getPackage() {
            return this.type.getPackage();
        }

        public String getSimpleName() {
            return this.type.getSimpleName();
        }

        public String getEnclosedName() {
            return this.type.getEnclosedName();
        }

        public String getQualifiedName() {
            return this.type.getQualifiedName();
        }

        public Iterable<IsAnnotation> getAnnotations() {
            return (Iterable)this.annotations.get();
        }

        public IsAnnotation getAnnotation(String name) {
            if (name.indexOf(46) == -1) {
                for (IsAnnotation anno : this.getAnnotations()) {
                    if (!anno.getSimpleName().equals(name)) continue;
                    return anno;
                }
            } else {
                for (IsAnnotation anno : this.getAnnotations()) {
                    if (!anno.getQualifiedName().equals(name)) continue;
                    return anno;
                }
            }
            return null;
        }

        public boolean isPublic() {
            return X_Modifier.isPublic((int)this.modifier);
        }

        public boolean isPrivate() {
            return X_Modifier.isPrivate((int)this.modifier);
        }

        public boolean isProtected() {
            return X_Modifier.isProtected((int)this.modifier);
        }

        public boolean isPackageProtected() {
            return X_Modifier.isPackage((int)this.modifier);
        }

        public boolean hasModifier(int modifier) {
            return X_Modifier.contains((int)this.modifier, (int)modifier);
        }

        public int getModifier() {
            return this.modifier;
        }

        public int hashCode() {
            return this.getQualifiedName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof IsType) {
                return ((IsType)obj).getQualifiedName().equals(this.getQualifiedName());
            }
            return false;
        }

        public String toString() {
            return this.getQualifiedName();
        }
    }

    class AnnotationAdapter
    implements IsAnnotation {
        private Annotation anno;
        private SingletonProvider<IsClass> annoClass = new SingletonProvider<IsClass>(){

            protected IsClass initialValue() {
                return BytecodeAdapterService.this.toClass(AnnotationAdapter.this.anno.getTypeName());
            }
        };
        private SingletonProvider<IsAnnotation> retentionAnno = new SingletonProvider<IsAnnotation>(){

            protected IsAnnotation initialValue() {
                return ((IsClass)AnnotationAdapter.this.annoClass.get()).getAnnotation(Retention.class.getName());
            }
        };

        public AnnotationAdapter(Annotation type) {
            this.anno = type;
        }

        public boolean isPrimitive() {
            return false;
        }

        public boolean isCompile() {
            IsAnnotation retention = (IsAnnotation)this.retentionAnno.get();
            if (retention == null) {
                return true;
            }
            IsMethod value = retention.getMethod("value", new IsType[0]);
            IsAnnotationValue val = retention.getValue(value);
            return RetentionPolicy.CLASS == val.getRawValue();
        }

        public boolean isRuntime() {
            IsAnnotation retention = (IsAnnotation)this.retentionAnno.get();
            if (retention == null) {
                return false;
            }
            IsMethod value = retention.getMethod("value", new IsType[0]);
            IsAnnotationValue val = retention.getValue(value);
            return RetentionPolicy.RUNTIME == val.getRawValue();
        }

        public boolean isSource() {
            IsAnnotation retention = (IsAnnotation)this.retentionAnno.get();
            if (retention == null) {
                return false;
            }
            IsMethod value = retention.getMethod("value", new IsType[0]);
            IsAnnotationValue val = retention.getValue(value);
            return RetentionPolicy.SOURCE == val.getRawValue();
        }

        public IsType getEnclosingType() {
            return ((IsClass)this.annoClass.get()).getEnclosingType();
        }

        public String getPackage() {
            return ((IsClass)this.annoClass.get()).getPackage();
        }

        public String getSimpleName() {
            return ((IsClass)this.annoClass.get()).getSimpleName();
        }

        public String getEnclosedName() {
            return ((IsClass)this.annoClass.get()).getEnclosedName();
        }

        public String getQualifiedName() {
            return ((IsClass)this.annoClass.get()).getQualifiedName();
        }

        public Iterable<IsMethod> getMethods() {
            return ((IsClass)this.annoClass.get()).getMethods();
        }

        public Iterable<IsMethod> getDeclaredMethods() {
            return ((IsClass)this.annoClass.get()).getDeclaredMethods();
        }

        public IsMethod getMethod(String name, IsType ... params) {
            return ((IsClass)this.annoClass.get()).getMethod(name, params);
        }

        public IsMethod getMethod(String name, boolean checkErased, Class<?> ... params) {
            return ((IsClass)this.annoClass.get()).getMethod(name, checkErased, (Class[])params);
        }

        public IsAnnotationValue getDefaultValue(IsMethod method) {
            return method.getDefaultValue();
        }

        public IsAnnotationValue getValue(IsMethod value) {
            MemberValue val = this.anno.getMemberValue(value.getName());
            if (val == null) {
                return this.getDefaultValue(value);
            }
            return BytecodeUtil.extractValue(val, BytecodeAdapterService.this, value.getReturnType());
        }

        public Object toAnnotation(ClassLoader loader) {
            throw new NotYetImplemented("AnnotationProxy not yet implemented");
        }

        public String toString() {
            return this.getQualifiedName();
        }

        public int hashCode() {
            return this.getQualifiedName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof IsAnnotation) {
                return ((IsAnnotation)obj).getQualifiedName().equals(this.getQualifiedName());
            }
            return false;
        }
    }
}

