/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.FoundViewHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public abstract class AbstractListenerHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder> {
    private IdAnnotationHelper helper;
    private EComponentWithViewSupportHolder holder;
    private String methodName;

    public AbstractListenerHandler(Class<?> targetClass, ProcessingEnvironment processingEnvironment) {
        super(targetClass, processingEnvironment);
    }

    public AbstractListenerHandler(String target, ProcessingEnvironment processingEnvironment) {
        super(target, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.helper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        this.validatorHelper.uniqueId(element, validatedElements, valid);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) {
        this.holder = holder;
        this.methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        TypeMirror returnType = executableElement.getReturnType();
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(this.processHolder, element, IRClass.Res.ID, true);
        JDefinedClass listenerAnonymousClass = this.codeModel().anonymousClass(this.getListenerClass());
        JMethod listenerMethod = this.createListenerMethod(listenerAnonymousClass);
        listenerMethod.annotate(Override.class);
        JBlock listenerMethodBody = listenerMethod.body();
        JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
        JInvocation call = JExpr.invoke((JExpression)activityRef, this.methodName);
        this.makeCall(listenerMethodBody, call, returnType);
        this.processParameters(holder, listenerMethod, call, parameters);
        for (JFieldRef idRef : idsRefs) {
            FoundViewHolder foundViewHolder = holder.getFoundViewHolder(idRef, this.getViewClass());
            foundViewHolder.getIfNotNullBlock().invoke(foundViewHolder.getView(), this.getSetterName()).arg(JExpr._new(listenerAnonymousClass));
        }
    }

    protected abstract void makeCall(JBlock var1, JInvocation var2, TypeMirror var3);

    protected abstract void processParameters(EComponentWithViewSupportHolder var1, JMethod var2, JInvocation var3, List<? extends VariableElement> var4);

    protected abstract JMethod createListenerMethod(JDefinedClass var1);

    protected abstract String getSetterName();

    protected abstract JClass getListenerClass();

    protected JClass getViewClass() {
        return this.classes().VIEW;
    }

    protected String getMethodName() {
        return this.methodName;
    }

    protected final EComponentWithViewSupportHolder getHolder() {
        return this.holder;
    }
}

