/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.RootContext;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EBeanHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class RootContextHanlder
extends BaseAnnotationHandler<EBeanHolder> {
    public RootContextHanlder(ProcessingEnvironment processingEnvironment) {
        super(RootContext.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEBeanAnnotation(element, validatedElements, valid);
        this.validatorHelper.extendsContext(element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EBeanHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror elementType = element.asType();
        String typeQualifiedName = elementType.toString();
        JBlock body = holder.getInitBody();
        JExpression contextRef = holder.getContextRef();
        if ("android.content.Context".equals(typeQualifiedName)) {
            body.assign(JExpr.ref(fieldName), contextRef);
        } else {
            JClass extendingContextClass = holder.refClass(typeQualifiedName);
            JConditional cond = body._if(holder.getContextRef()._instanceof(extendingContextClass));
            cond._then().assign(JExpr.ref(fieldName), JExpr.cast(extendingContextClass, holder.getContextRef()));
            JInvocation warningInvoke = holder.classes().LOG.staticInvoke("w");
            warningInvoke.arg(holder.getGeneratedClass().name());
            JExpression expr = JExpr.lit("Due to Context class ").plus(holder.getContextRef().invoke("getClass").invoke("getSimpleName")).plus(JExpr.lit(", the @RootContext " + extendingContextClass.name() + " won't be populated"));
            warningInvoke.arg(expr);
            cond._else().add(warningInvoke);
        }
    }
}

