/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JMethod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.CanonicalNameConstants;

public class BundleHelper {
    public static final Map<String, String> methodSuffixNameByTypeName = new HashMap<String, String>();
    private AnnotationHelper annotationHelper;
    private APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    private TypeMirror element;
    private boolean restoreCallNeedCastStatement = false;
    private boolean restoreCallNeedsSuppressWarning = false;
    private String methodNameToSave;
    private String methodNameToRestore;

    public BundleHelper(AnnotationHelper helper, TypeMirror element) {
        this.annotationHelper = helper;
        this.element = element;
        String typeString = element.toString();
        TypeElement elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
        if (methodSuffixNameByTypeName.containsKey(typeString)) {
            this.methodNameToSave = "put" + methodSuffixNameByTypeName.get(typeString);
            this.methodNameToRestore = "get" + methodSuffixNameByTypeName.get(typeString);
        } else if (element.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)element;
            boolean hasTypeArguments = false;
            if (arrayType.getComponentType() instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)arrayType.getComponentType();
                typeString = declaredType.asElement().toString();
                hasTypeArguments = declaredType.getTypeArguments().size() > 0;
            } else {
                typeString = arrayType.getComponentType().toString();
            }
            elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
            if (this.isTypeParcelable(elementType)) {
                this.methodNameToSave = "putParcelableArray";
                this.methodNameToRestore = "getParcelableArray";
                this.restoreCallNeedCastStatement = true;
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            } else {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
            }
        } else if (typeString.startsWith(CanonicalNameConstants.ARRAYLIST)) {
            DeclaredType declaredType;
            List<? extends TypeMirror> typeArguments;
            boolean hasTypeArguments = false;
            if (element instanceof DeclaredType && (typeArguments = (declaredType = (DeclaredType)element).getTypeArguments()).size() == 1) {
                TypeMirror typeArgument = typeArguments.get(0);
                if (typeArgument instanceof DeclaredType) {
                    declaredType = (DeclaredType)typeArgument;
                    typeString = declaredType.asElement().toString();
                    elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
                    boolean bl = hasTypeArguments = declaredType.getTypeArguments().size() > 0;
                }
                if (this.isTypeParcelable(elementType)) {
                    this.methodNameToSave = "putParcelableArrayList";
                    this.methodNameToRestore = "getParcelableArrayList";
                    if (hasTypeArguments) {
                        this.restoreCallNeedsSuppressWarning = true;
                    }
                }
            }
            if (this.methodNameToSave == null) {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            }
        } else {
            boolean hasTypeArguments = false;
            if (element instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)element;
                typeString = declaredType.asElement().toString();
                elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
                boolean bl = hasTypeArguments = declaredType.getTypeArguments().size() > 0;
            }
            if (this.isTypeParcelable(elementType)) {
                this.methodNameToSave = "putParcelable";
                this.methodNameToRestore = "getParcelable";
            } else {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            }
        }
    }

    public boolean restoreCallNeedCastStatement() {
        return this.restoreCallNeedCastStatement;
    }

    public boolean restoreCallNeedsSuppressWarning() {
        return this.restoreCallNeedsSuppressWarning;
    }

    public String getMethodNameToSave() {
        return this.methodNameToSave;
    }

    public String getMethodNameToRestore() {
        return this.methodNameToRestore;
    }

    private boolean isTypeParcelable(TypeElement elementType) {
        TypeElement parcelableType = this.annotationHelper.typeElementFromQualifiedName("android.os.Parcelable");
        return elementType != null && this.annotationHelper.isSubtype(elementType, parcelableType);
    }

    public JExpression getExpressionToRestoreFromIntentOrBundle(JClass variableClass, JExpression intent, JExpression extras, JExpression extraKey, JMethod method) {
        if ("byte[]".equals(this.element.toString())) {
            return intent.invoke("getByteArrayExtra").arg(extraKey);
        }
        return this.getExpressionToRestoreFromBundle(variableClass, extras, extraKey, method);
    }

    public JExpression getExpressionToRestoreFromBundle(JClass variableClass, JExpression bundle, JExpression extraKey, JMethod method) {
        JExpressionImpl expressionToRestore = JExpr.invoke(bundle, this.methodNameToRestore).arg(extraKey);
        if (this.restoreCallNeedCastStatement()) {
            expressionToRestore = JExpr.cast(variableClass, expressionToRestore);
            if (this.restoreCallNeedsSuppressWarning() && !this.codeModelHelper.hasAnnotation((JAnnotatable)method, SuppressWarnings.class)) {
                method.annotate(SuppressWarnings.class).param("value", "unchecked");
            }
        }
        return expressionToRestore;
    }

    static {
        methodSuffixNameByTypeName.put("android.os.Bundle", "Bundle");
        methodSuffixNameByTypeName.put("boolean", "Boolean");
        methodSuffixNameByTypeName.put("boolean[]", "BooleanArray");
        methodSuffixNameByTypeName.put("byte", "Byte");
        methodSuffixNameByTypeName.put("byte[]", "ByteArray");
        methodSuffixNameByTypeName.put("char", "Char");
        methodSuffixNameByTypeName.put("char[]", "CharArray");
        methodSuffixNameByTypeName.put(CanonicalNameConstants.CHAR_SEQUENCE, "CharSequence");
        methodSuffixNameByTypeName.put("double", "Double");
        methodSuffixNameByTypeName.put("double[]", "DoubleArray");
        methodSuffixNameByTypeName.put("float", "Float");
        methodSuffixNameByTypeName.put("float[]", "FloatArray");
        methodSuffixNameByTypeName.put("int", "Int");
        methodSuffixNameByTypeName.put("int[]", "IntArray");
        methodSuffixNameByTypeName.put("java.util.ArrayList<java.lang.Integer>", "IntegerArrayList");
        methodSuffixNameByTypeName.put("long", "Long");
        methodSuffixNameByTypeName.put("long[]", "LongArray");
        methodSuffixNameByTypeName.put("short", "Short");
        methodSuffixNameByTypeName.put("short[]", "ShortArray");
        methodSuffixNameByTypeName.put(CanonicalNameConstants.STRING, "String");
        methodSuffixNameByTypeName.put("java.lang.String[]", "StringArray");
        methodSuffixNameByTypeName.put("java.util.ArrayList<java.lang.String>", "StringArrayList");
    }
}

