/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.logger;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.androidannotations.helper.OptionsHelper;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.appender.Appender;
import org.androidannotations.logger.appender.ConsoleAppender;
import org.androidannotations.logger.appender.FileAppender;
import org.androidannotations.logger.appender.MessagerAppender;
import org.androidannotations.logger.formatter.Formatter;

public class LoggerContext {
    private static LoggerContext INSTANCE = null;
    private static final Level DEFAULT_LEVEL = Level.DEBUG;
    private Level currentLevel = DEFAULT_LEVEL;
    private List<Appender> appenders = new ArrayList<Appender>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoggerContext getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<LoggerContext> clazz = LoggerContext.class;
        synchronized (LoggerContext.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new LoggerContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    LoggerContext() {
        this.appenders.add(new FileAppender());
        this.appenders.add(new MessagerAppender());
    }

    public void writeLog(Level level, String loggerName, String message, Element element, AnnotationMirror annotationMirror, Throwable thr, Object ... args) {
        for (Appender appender : this.appenders) {
            Formatter formatter = appender.getFormatter();
            String log = formatter.buildLog(level, loggerName, message, thr, args);
            appender.append(level, element, annotationMirror, log);
        }
    }

    public Level getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(Level currentLevel) {
        this.currentLevel = currentLevel;
    }

    public void setProcessingEnv(ProcessingEnvironment processingEnv) {
        OptionsHelper optionsHelper = new OptionsHelper(processingEnv);
        this.resolveLogLevel(optionsHelper);
        this.addConsoleAppender(optionsHelper);
        for (Appender appender : this.appenders) {
            appender.setProcessingEnv(processingEnv);
            appender.open();
        }
    }

    public void close() {
        for (Appender appender : this.appenders) {
            appender.close();
        }
    }

    private void resolveLogLevel(OptionsHelper optionsHelper) {
        this.setCurrentLevel(optionsHelper.getLogLevel());
    }

    private void addConsoleAppender(OptionsHelper optionsHelper) {
        if (optionsHelper.shouldUseConsoleAppender()) {
            this.appenders.add(new ConsoleAppender());
        }
    }
}

