/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.asterisk.manager.AsteriskServer;
import net.sf.asterisk.manager.ChannelStateEnum;
import net.sf.asterisk.manager.Extension;

public class Channel
implements Serializable {
    private static final long serialVersionUID = -6919877370396385380L;
    private AsteriskServer asteriskServer;
    private final String id;
    private String name;
    private String callerId;
    private String callerIdName;
    private ChannelStateEnum state;
    private String account;
    private final List extensions;
    private Date dateOfCreation;
    private Channel linkedChannel;
    private boolean wasLinked;

    public Channel(String name, String id) {
        this(name, id, null);
    }

    public Channel(String name, String id, AsteriskServer server) {
        this.name = name;
        this.id = id;
        this.asteriskServer = server;
        this.extensions = new ArrayList();
    }

    public final AsteriskServer getAsteriskServer() {
        return this.asteriskServer;
    }

    public final void setAsteriskServer(AsteriskServer asteriskServer) {
        this.asteriskServer = asteriskServer;
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getCallerId() {
        return this.callerId;
    }

    public final void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public final String getCallerIdName() {
        return this.callerIdName;
    }

    public final void setCallerIdName(String callerIdName) {
        this.callerIdName = callerIdName;
    }

    public final ChannelStateEnum getState() {
        return this.state;
    }

    public final void setState(ChannelStateEnum state) {
        this.state = state;
    }

    public final String getAccount() {
        return this.account;
    }

    public final void setAccount(String account) {
        this.account = account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Extension getCurrentExtension() {
        Extension extension;
        List list = this.extensions;
        synchronized (list) {
            extension = this.extensions.isEmpty() ? null : (Extension)this.extensions.get(this.extensions.size() - 1);
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension getFirstExtension() {
        Extension extension;
        List list = this.extensions;
        synchronized (list) {
            extension = this.extensions.isEmpty() ? null : (Extension)this.extensions.get(0);
        }
        return extension;
    }

    public String getContext() {
        Extension currentExtension = this.getCurrentExtension();
        return currentExtension == null ? null : currentExtension.getContext();
    }

    public String getExtension() {
        Extension currentExtension = this.getCurrentExtension();
        return currentExtension == null ? null : currentExtension.getExtension();
    }

    public Integer getPriority() {
        Extension currentExtension = this.getCurrentExtension();
        return currentExtension == null ? null : currentExtension.getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getExtensions() {
        ArrayList extensionsCopy;
        List list = this.extensions;
        synchronized (list) {
            extensionsCopy = new ArrayList(this.extensions);
        }
        return extensionsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtension(Extension extension) {
        List list = this.extensions;
        synchronized (list) {
            this.extensions.add(extension);
        }
    }

    public final Date getDateOfCreation() {
        return this.dateOfCreation;
    }

    public final void setDateOfCreation(Date dateOfCreation) {
        this.dateOfCreation = dateOfCreation;
    }

    public final Channel getLinkedChannel() {
        return this.linkedChannel;
    }

    public final void setLinkedChannel(Channel linkedChannel) {
        this.linkedChannel = linkedChannel;
        if (linkedChannel != null) {
            this.wasLinked = true;
        }
    }

    public final boolean getWasLinked() {
        return this.wasLinked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int systemHashcode;
        Channel linkedChannel;
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        Channel channel = this;
        synchronized (channel) {
            sb.append("id='" + this.getId() + "'; ");
            sb.append("name='" + this.getName() + "'; ");
            sb.append("callerId='" + this.getCallerId() + "'; ");
            sb.append("state='" + this.getState() + "'; ");
            sb.append("account='" + this.getAccount() + "'; ");
            sb.append("dateOfCreation=" + this.getDateOfCreation() + "; ");
            linkedChannel = this.linkedChannel;
            systemHashcode = System.identityHashCode(this);
        }
        if (linkedChannel == null) {
            sb.append("linkedChannel=null; ");
        } else {
            sb.append("linkedChannel=[");
            channel = linkedChannel;
            synchronized (channel) {
                sb.append(linkedChannel.getClass().getName() + ": ");
                sb.append("id='" + linkedChannel.getId() + "'; ");
                sb.append("name='" + linkedChannel.getName() + "'; ");
                sb.append("systemHashcode=" + System.identityHashCode(linkedChannel));
            }
            sb.append("]; ");
        }
        sb.append("systemHashcode=" + systemHashcode);
        return sb.toString();
    }
}

