/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.GeneratedCodeClass;

public class GeneratedClassLoader
extends ClassLoader {
    private Set generatedClasses = new HashSet();

    public GeneratedClassLoader() {
    }

    public GeneratedClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class defineClass(GeneratedCodeClass cc) throws CodeException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            cc.createCode(bos);
            byte[] code = bos.toByteArray();
            Class<?> clazz = this.defineClass(cc.getName(), code, 0, code.length);
            this.generatedClasses.add(clazz.getName());
            return clazz;
        }
        catch (IOException ex) {
            throw new CodeException();
        }
    }

    public boolean hasGeneratedClass(String name) {
        return this.generatedClasses.contains(name);
    }
}

